/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultConfiguration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexingMode;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.util.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.lucene.store.Directory;

public class MockIndexDirectoryFactory
implements IndexDirectoryFactory {
    private final Function<IndexDirectoryFactory.Name, Directory> directorySupplier;
    private final ApplicationProperties applicationProperties;
    private String rootPath = "/some/stuff/";
    private volatile IndexingMode mode = IndexingMode.QUEUED;

    public MockIndexDirectoryFactory(Function<IndexDirectoryFactory.Name, Directory> directorySupplier, ApplicationProperties applicationProperties) {
        this.directorySupplier = directorySupplier;
        this.applicationProperties = applicationProperties;
    }

    public Map<IndexDirectoryFactory.Name, Index.Manager> get() {
        EnumMap<IndexDirectoryFactory.Name, Index.Manager> indexes = new EnumMap<IndexDirectoryFactory.Name, Index.Manager>(IndexDirectoryFactory.Name.class);
        for (IndexDirectoryFactory.Name type : IndexDirectoryFactory.Name.values()) {
            indexes.put(type, this.mode.createIndexManager(type.name(), (Configuration)new DefaultConfiguration((Directory)this.directorySupplier.apply((Object)type), IssueIndexer.Analyzers.INDEXING), this.applicationProperties));
        }
        return Collections.unmodifiableMap(indexes);
    }

    public List<String> getIndexPaths() {
        return Lists.newArrayList((Object[])new String[]{this.rootPath + "issues", this.rootPath + "comments"});
    }

    public String getIndexRootPath() {
        return this.rootPath;
    }

    public void setIndexRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setIndexingMode(@Nonnull IndexingMode mode) {
        this.mode = mode;
    }
}

