/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.junit;

import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log4jLoggerTestUtil {
    private static final String APPENDER_NAME = "Log4jLoggerTestAppender";
    private final String category;
    private StringWriter writer;

    public Log4jLoggerTestUtil() {
        this("");
    }

    public Log4jLoggerTestUtil(String category) {
        this.category = category;
    }

    public Log4jLoggerTestUtil(Class<?> clazz) {
        this(clazz.getName());
    }

    public void beforeTest() {
        this.writer = new StringWriter();
        WriterAppender writerAppender = ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName("Log4jLoggerTestAppender-" + UUID.randomUUID())).setTarget((Writer)this.writer).setLayout((Layout)PatternLayout.newBuilder().withPattern("%level - %m%n").build())).build();
        Logger logger = this.getLogger();
        writerAppender.start();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)LogManager.class.getClassLoader(), (boolean)false);
        Configuration config = ctx.getConfiguration();
        if (this.isRootLogger()) {
            config.getLoggers().values().forEach(loggerConfig -> {
                loggerConfig.setLevel(Level.ALL);
                loggerConfig.addAppender((Appender)writerAppender, Level.ALL, null);
            });
        } else {
            String loggerName = logger.getName();
            LoggerConfig loggerConfig2 = config.getLoggerConfig(loggerName);
            if (!loggerConfig2.getName().equals(loggerName)) {
                loggerConfig2 = LoggerConfig.newBuilder().withLoggerName(loggerName).withAdditivity(false).withLevel(Level.ALL).withRefs(new AppenderRef[]{AppenderRef.createAppenderRef((String)APPENDER_NAME, (Level)Level.ALL, null)}).withConfig(config).build();
                config.addLogger(loggerName, loggerConfig2);
                loggerConfig2.addAppender((Appender)writerAppender, Level.ALL, null);
            } else {
                loggerConfig2.setLevel(Level.ALL);
                loggerConfig2.addAppender((Appender)writerAppender, Level.ALL, null);
            }
        }
        ctx.updateLoggers();
    }

    public void afterTest() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)LogManager.class.getClassLoader(), (boolean)false);
        ctx.reconfigure();
        ctx.updateLoggers();
    }

    public void setLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((ClassLoader)LogManager.class.getClassLoader(), (boolean)false);
        Configuration config = ctx.getConfiguration();
        if (this.isRootLogger()) {
            config.getLoggers().values().forEach(loggerConfig -> loggerConfig.setLevel(level));
        } else {
            LoggerConfig loggerConfig2 = config.getLoggerConfig(this.getLogger().getName());
            loggerConfig2.setLevel(level);
        }
        ctx.updateLoggers();
    }

    public String getMessage() {
        return this.writer.toString();
    }

    public void reset() {
        StringBuffer buffer = this.writer.getBuffer();
        buffer.delete(0, buffer.length());
    }

    public void setLevel(org.apache.log4j.Level level) {
        this.setLevel(Level.getLevel((String)level.toString()));
    }

    private Logger getLogger() {
        return (Logger)(StringUtils.isBlank((CharSequence)this.category) ? LogManager.getRootLogger() : LogManager.getLogger((String)this.category));
    }

    private boolean isRootLogger() {
        return StringUtils.isBlank((CharSequence)this.category);
    }
}

