/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.license.LicensedApplications;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MockLicensedApplications
implements LicensedApplications {
    private Map<ApplicationKey, Integer> applicationUserCounts;

    public MockLicensedApplications() {
        this.applicationUserCounts = new HashMap<ApplicationKey, Integer>();
    }

    public MockLicensedApplications(@Nonnull Map<ApplicationKey, Integer> applicationsWithCounts) {
        this.applicationUserCounts = new HashMap<ApplicationKey, Integer>(applicationsWithCounts);
    }

    public MockLicensedApplications(@Nonnull Iterable<ApplicationKey> roles) {
        this();
        for (ApplicationKey role : roles) {
            this.applicationUserCounts.put(role, -1);
        }
    }

    public MockLicensedApplications(ApplicationKey ... roles) {
        this(Arrays.asList(roles));
    }

    public MockLicensedApplications addSeats(@Nonnull ApplicationKey application, int numSeats) {
        assert (numSeats > 0);
        int currentSeats = this.getUserLimit(application);
        if (currentSeats == -1) {
            return this;
        }
        this.applicationUserCounts.put(application, numSeats + currentSeats);
        return this;
    }

    @Nonnull
    public Set<ApplicationKey> getKeys() {
        return this.applicationUserCounts.keySet();
    }

    public int getUserLimit(@Nonnull ApplicationKey role) {
        Integer numSeats = this.applicationUserCounts.get(role);
        return numSeats != null ? numSeats : 0;
    }

    @Nonnull
    public String getDescription() {
        return "";
    }

    public boolean hasNativeRole() {
        return false;
    }

    public String toString() {
        return this.applicationUserCounts.keySet().toString();
    }
}

