/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ErrorCollectionMatcher
extends TypeSafeDiagnosingMatcher<ErrorCollection> {
    private final ErrorCollection expected;
    private final boolean expectedNoErrors;
    private final boolean expectSingleError;

    public ErrorCollectionMatcher(ErrorCollection errorCollection, boolean expectedNoErrors, boolean expectSingleError) {
        this.expected = errorCollection;
        this.expectedNoErrors = expectedNoErrors;
        this.expectSingleError = expectSingleError;
    }

    public static ErrorCollectionMatcher hasError(String fieldName, String errorMessage) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addError(fieldName, errorMessage);
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, false);
    }

    public static ErrorCollectionMatcher hasError(String fieldName, String errorMessage, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addError(fieldName, errorMessage);
        errorCollection.setReasons((Set)ImmutableSet.of((Object)reason));
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, false);
    }

    public static ErrorCollectionMatcher hasOnlyError(String fieldName, String errorMessage) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addError(fieldName, errorMessage);
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, true);
    }

    public static ErrorCollectionMatcher hasErrorMessage(String errorMessage) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(errorMessage);
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, false);
    }

    public static ErrorCollectionMatcher hasOnlyErrorMessage(String errorMessage) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(errorMessage);
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, true);
    }

    public static ErrorCollectionMatcher hasErrorMessage(String errorMessage, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(errorMessage, reason);
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, false);
    }

    public static ErrorCollectionMatcher hasOnlyErrorMessage(String errorMessage, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(errorMessage, reason);
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, true);
    }

    public static ErrorCollectionMatcher hasErrorMessages(String ... errorMessage) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessages((Collection)Lists.newArrayList((Object[])errorMessage));
        return new ErrorCollectionMatcher((ErrorCollection)errorCollection, false, false);
    }

    public static ErrorCollectionMatcher hasErrors(@Nonnull ErrorCollection errorCollection) {
        return new ErrorCollectionMatcher(errorCollection, false, false);
    }

    public static ErrorCollectionMatcher hasNoErrors() {
        return new ErrorCollectionMatcher(null, true, false);
    }

    protected boolean matchesSafely(ErrorCollection errorCollection, Description description) {
        int expectedErrorsCount;
        int errorsCount;
        boolean hasErrorMessages = errorCollection.getErrorMessages() != null && !errorCollection.getErrorMessages().isEmpty();
        boolean hasErrors = errorCollection.getErrors() != null && !errorCollection.getErrors().isEmpty();
        int errorMessagesCount = hasErrorMessages ? errorCollection.getErrorMessages().size() : 0;
        int n = errorsCount = hasErrors ? errorCollection.getErrors().size() : 0;
        if (this.expectedNoErrors) {
            if (errorCollection.hasAnyErrors() || hasErrorMessages || hasErrors) {
                description.appendText(String.format("Has errors: %s %n", this.toString(errorCollection)));
                return false;
            }
            return true;
        }
        boolean expectedErrorMessages = this.expected.getErrorMessages() != null && !this.expected.getErrorMessages().isEmpty();
        boolean expectedErrors = this.expected.getErrors() != null && !this.expected.getErrors().isEmpty();
        boolean expectedReasons = this.expected.getReasons() != null && !this.expected.getReasons().isEmpty();
        int expectedErrorMessagesCount = expectedErrorMessages ? this.expected.getErrorMessages().size() : 0;
        int n2 = expectedErrorsCount = expectedErrors ? this.expected.getErrors().size() : 0;
        if (this.expectSingleError) {
            if (errorMessagesCount + errorsCount != 1) {
                description.appendText(String.format("Has more than one error: %s %n", this.toString(errorCollection)));
                return false;
            }
            if (expectedErrorMessages && !this.expected.getErrorMessages().equals(errorCollection.getErrorMessages())) {
                this.appendError(errorCollection, description);
                return false;
            }
            if (expectedErrors && !this.expected.getErrors().equals(errorCollection.getErrors())) {
                this.appendError(errorCollection, description);
                return false;
            }
        }
        if (errorMessagesCount < expectedErrorMessagesCount || errorsCount < expectedErrorsCount) {
            this.appendError(errorCollection, description);
            return false;
        }
        if (expectedErrorMessages && !errorCollection.getErrorMessages().containsAll(this.expected.getErrorMessages())) {
            this.appendError(errorCollection, description);
            return false;
        }
        if (expectedErrors) {
            if (!Maps.difference((Map)errorCollection.getErrors(), (Map)this.expected.getErrors()).entriesOnlyOnRight().isEmpty()) {
                this.appendError(errorCollection, description);
                return false;
            }
            for (String key : this.expected.getErrors().keySet()) {
                if (((String)errorCollection.getErrors().get(key)).equals(this.expected.getErrors().get(key))) continue;
                this.appendError(errorCollection, description);
                return false;
            }
        }
        if (expectedReasons && !errorCollection.getReasons().containsAll(this.expected.getReasons())) {
            this.appendError(errorCollection, description);
            return false;
        }
        return true;
    }

    private void appendError(ErrorCollection errorCollection, Description description) {
        description.appendText(String.format("Found: %s %n", this.toString(errorCollection)));
    }

    public void describeTo(Description description) {
        if (this.expectedNoErrors) {
            description.appendText("No errors");
            return;
        }
        description.appendText(this.toString(this.expected));
    }

    private String toString(ErrorCollection errorCollection) {
        return String.format("[ErrorMessages: {%s}, Errors: {%s}, Reasons: {%s}]", errorCollection.getErrorMessages() == null ? "null" : StringUtils.join((Iterable)errorCollection.getErrorMessages(), (char)','), errorCollection.getErrors() == null ? "null" : StringUtils.join(errorCollection.getErrors().entrySet(), (char)','), errorCollection.getReasons() == null ? "null" : StringUtils.join((Iterable)errorCollection.getReasons(), (char)','));
    }
}

