/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class LuceneDocumentMatchers {
    public static FieldHasStringValue fieldHasStringValue(Matcher<? super String> stringValueMatcher) {
        return new FieldHasStringValue(stringValueMatcher);
    }

    public static FieldHasBytesRefValue fieldHasBytesRefValue(Matcher<? super BytesRef> bytesRefValueMatcher) {
        return new FieldHasBytesRefValue(bytesRefValueMatcher);
    }

    public static FieldHasLongValue fieldHasLongValue(Matcher<? super Long> numberValueMatcher) {
        return new FieldHasLongValue(numberValueMatcher);
    }

    public static DocumentFieldMatcher hasFieldThat(String fieldName, Matcher<IndexableField> expectedValue) {
        return new DocumentFieldMatcher(fieldName, expectedValue);
    }

    public static DocumentFieldMatcher hasStringField(String fieldName, String expectedValue) {
        Matcher string = Matchers.equalTo((Object)expectedValue);
        return LuceneDocumentMatchers.hasFieldThat(fieldName, (Matcher<IndexableField>)LuceneDocumentMatchers.fieldHasStringValue((Matcher<? super String>)string));
    }

    public static FieldHasStoredValue fieldHasStoredValue() {
        return new FieldHasStoredValue((Matcher<? super Boolean>)Matchers.equalTo((Object)true));
    }

    public static FieldHasName fieldHasName(String expectedFieldName) {
        return new FieldHasName((Matcher<? super String>)Matchers.equalTo((Object)expectedFieldName));
    }

    public static FieldHasDimensions fieldHasDimensions(int expectedDimensionCount) {
        return new FieldHasDimensions((Matcher<? super Integer>)Matchers.equalTo((Object)expectedDimensionCount));
    }

    public static class FieldHasDimensions
    extends FeatureMatcher<IndexableField, Integer> {
        public FieldHasDimensions(Matcher<? super Integer> subMatcher) {
            super(subMatcher, "field with a value", "Number value");
        }

        protected Integer featureValueOf(IndexableField actual) {
            return actual.fieldType().pointDimensionCount();
        }
    }

    public static class FieldHasStoredValue
    extends FeatureMatcher<IndexableField, Boolean> {
        public FieldHasStoredValue(Matcher<? super Boolean> subMatcher) {
            super(subMatcher, "field with a value", "Stored value");
        }

        protected Boolean featureValueOf(IndexableField actual) {
            return actual.fieldType().stored();
        }
    }

    public static class FieldHasName
    extends FeatureMatcher<IndexableField, String> {
        public FieldHasName(Matcher<? super String> subMatcher) {
            super(subMatcher, "field with a value", "Field name value");
        }

        protected String featureValueOf(IndexableField actual) {
            return actual.name();
        }
    }

    public static class FieldHasLongValue
    extends FeatureMatcher<IndexableField, Long> {
        public FieldHasLongValue(Matcher<? super Long> subMatcher) {
            super(subMatcher, "field with a value", "Number value");
        }

        protected Long featureValueOf(IndexableField actual) {
            return actual.numericValue().longValue();
        }
    }

    public static class FieldHasBytesRefValue
    extends FeatureMatcher<IndexableField, BytesRef> {
        public FieldHasBytesRefValue(Matcher<? super BytesRef> subMatcher) {
            super(subMatcher, "field with a value", "BytesRef value");
        }

        protected BytesRef featureValueOf(IndexableField actual) {
            return actual.binaryValue();
        }
    }

    public static class FieldHasStringValue
    extends FeatureMatcher<IndexableField, String> {
        public FieldHasStringValue(Matcher<? super String> subMatcher) {
            super(subMatcher, "field with a value", "String value");
        }

        protected String featureValueOf(IndexableField actual) {
            return actual.stringValue();
        }
    }

    public static class DocumentFieldMatcher
    extends FeatureMatcher<Document, IndexableField> {
        private final String fieldName;

        public DocumentFieldMatcher(String fieldName, Matcher<? super IndexableField> fieldMatcher) {
            super(fieldMatcher, "a document with a field \"" + fieldName + "\"", fieldName);
            this.fieldName = fieldName;
        }

        protected IndexableField featureValueOf(Document actual) {
            return actual.getField(this.fieldName);
        }
    }
}

