/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import io.atlassian.fugue.Option;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public abstract class OptionMatchers<T>
extends TypeSafeDiagnosingMatcher<Option<T>> {
    public static <T> OptionMatchers<T> none() {
        return new NoneMatchers();
    }

    public static <T> OptionMatchers<T> none(Class<? extends T> ignored) {
        return new NoneMatchers();
    }

    public static <T> OptionMatchers<T> some(Matcher<? super T> matcher) {
        return new SomeMatchers(matcher);
    }

    public static <T> OptionMatchers<T> some(T value) {
        return new SomeMatchers(Matchers.equalTo(value));
    }

    public static <T> OptionMatchers<T> fromOption(Option<T> option) {
        return (OptionMatchers)((Object)option.map(OptionMatchers::some).getOrElse(OptionMatchers.none()));
    }

    private static class SomeMatchers<T>
    extends OptionMatchers<T> {
        private final Matcher<? super T> matcher;

        private SomeMatchers(Matcher<? super T> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Option<T> item, Description mismatchDescription) {
            if (item.isEmpty()) {
                mismatchDescription.appendValue(item);
                return false;
            }
            if (this.matcher.matches(item.get())) {
                return true;
            }
            mismatchDescription.appendText("some(");
            this.matcher.describeMismatch(item.get(), mismatchDescription);
            mismatchDescription.appendText(")");
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("some(").appendDescriptionOf(this.matcher).appendText(")");
        }
    }

    private static class NoneMatchers<T>
    extends OptionMatchers<T> {
        private NoneMatchers() {
        }

        protected boolean matchesSafely(Option<T> item, Description mismatchDescription) {
            if (item.isEmpty()) {
                return true;
            }
            mismatchDescription.appendValue(item);
            return false;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)Option.none());
        }
    }
}

