/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class QueryLiteralMatchers {
    private QueryLiteralMatchers() {
    }

    public static Matcher<Iterable<QueryLiteral>> emptyIterable() {
        return Matchers.emptyIterableOf(QueryLiteral.class);
    }

    public static Matcher<QueryLiteral> literal() {
        return new TypeSafeMatcher<QueryLiteral>(){

            protected boolean matchesSafely(QueryLiteral item) {
                return item.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("QueryLiteral[EMPTY]");
            }
        };
    }

    public static Matcher<QueryLiteral> literal(final String expectedStringValue) {
        if (expectedStringValue == null) {
            return QueryLiteralMatchers.literal();
        }
        return new TypeSafeMatcher<QueryLiteral>(){

            protected boolean matchesSafely(QueryLiteral item) {
                return expectedStringValue.equals(item.getStringValue());
            }

            public void describeTo(Description description) {
                description.appendText("QueryLiteral[\"").appendValue((Object)expectedStringValue).appendText("\"]");
            }
        };
    }

    public static Matcher<QueryLiteral> literal(final Long expectedLongValue) {
        if (expectedLongValue == null) {
            return QueryLiteralMatchers.literal();
        }
        return new TypeSafeMatcher<QueryLiteral>(){

            protected boolean matchesSafely(QueryLiteral item) {
                return expectedLongValue.equals(item.getLongValue());
            }

            public void describeTo(Description description) {
                description.appendText("QueryLiteral[").appendValue((Object)expectedLongValue).appendText("]");
            }
        };
    }

    public static Matcher<? super QueryLiteral> literal(Object expectedValue) {
        if (expectedValue == null) {
            return QueryLiteralMatchers.literal();
        }
        if (expectedValue instanceof String) {
            return QueryLiteralMatchers.literal((String)expectedValue);
        }
        if (expectedValue instanceof Long) {
            return QueryLiteralMatchers.literal((Long)expectedValue);
        }
        if (expectedValue instanceof QueryLiteral) {
            return Matchers.equalTo((Object)((QueryLiteral)expectedValue));
        }
        throw new IllegalArgumentException("Cannot match instance of " + expectedValue.getClass().getName() + " as a QueryLiteral");
    }

    public static Matcher<Iterable<? extends QueryLiteral>> literals(Object ... values) {
        ArrayList itemMatchers = Lists.newArrayList(Arrays.stream(values).map(QueryLiteralMatchers::literal).iterator());
        return Matchers.contains((List)itemMatchers);
    }

    public static Matcher<Iterable<? extends QueryLiteral>> literals(List<?> values) {
        ArrayList itemMatchers = Lists.newArrayList(values.stream().map(QueryLiteralMatchers::literal).iterator());
        return Matchers.contains((List)itemMatchers);
    }
}

