/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.DefaultPermissionManager;
import com.atlassian.jira.security.JiraPermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class MockPermissionManager
extends DefaultPermissionManager {
    protected Collection<JiraPermission> permissions;
    private boolean defaultPermission;

    public boolean isDefaultPermission() {
        return this.defaultPermission;
    }

    public void setDefaultPermission(boolean defaultPermission) {
        this.defaultPermission = defaultPermission;
    }

    public MockPermissionManager() {
        super(null, null, null);
        this.permissions = new HashSet<JiraPermission>(4);
    }

    public MockPermissionManager(boolean defaultPermission) {
        super(null, null, null);
        this.defaultPermission = defaultPermission;
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        Iterator<JiraPermission> iterator = this.permissions.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getGroup().equals(group)) continue;
            iterator.remove();
        }
    }

    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        return this.defaultPermission;
    }

    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        return this.defaultPermission;
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        return this.defaultPermission;
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        return this.defaultPermission;
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey projectPermissionKey, @Nonnull Project project, ApplicationUser user, boolean issueCreation) {
        return this.defaultPermission;
    }

    public boolean hasProjects(int permissionId, ApplicationUser user) {
        return this.defaultPermission;
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey projectPermissionKey, @Nonnull Project project, ApplicationUser user) {
        return this.defaultPermission;
    }
}

