/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.DefaultRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.MockApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockProjectRoleManager
implements ProjectRoleManager {
    public static final ProjectRole PROJECT_ROLE_TYPE_1 = new ProjectRoleImpl(Long.valueOf(1L), "Project Administrator", "Can change settings about this project");
    public static final ProjectRole PROJECT_ROLE_TYPE_2 = new ProjectRoleImpl(Long.valueOf(2L), "Developer", "Works on this project");
    public static final ProjectRole PROJECT_ROLE_TYPE_3 = new ProjectRoleImpl(Long.valueOf(3L), "User", "Acts as a participant on this project");
    public static final ProjectRole PROJECT_ROLE_TYPE_NULL = new ProjectRoleImpl(null, null, null);
    public static final List<ProjectRole> DEFAULT_ROLE_TYPES = ImmutableList.of((Object)PROJECT_ROLE_TYPE_1, (Object)PROJECT_ROLE_TYPE_2, (Object)PROJECT_ROLE_TYPE_3);
    private Collection<ProjectRole> projectRoles = Lists.newArrayList(DEFAULT_ROLE_TYPES);
    private long idCounter = this.projectRoles.size();

    public Collection<ProjectRole> getProjectRoles() {
        return this.projectRoles;
    }

    public Collection<ProjectRole> getProjectRoles(ApplicationUser user, Project project) {
        return null;
    }

    public ProjectRole getProjectRole(Long id) {
        for (ProjectRole o : this.getProjectRoles()) {
            ProjectRole role = o;
            if (!role.getId().equals(id)) continue;
            return role;
        }
        return null;
    }

    public ProjectRole getProjectRole(String name) {
        for (ProjectRole o : this.getProjectRoles()) {
            ProjectRole role = o;
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public void addRole(ProjectRole projectRole) {
        this.checkRoleNameUnique(projectRole.getName());
        if (this.getProjectRole(projectRole.getId()) != null) {
            throw new IllegalArgumentException("Role with id '" + projectRole.getId() + "' already exists.");
        }
        this.projectRoles.add(projectRole);
    }

    public ProjectRole createRole(ProjectRole projectRole) {
        MockProjectRole role = new MockProjectRole(++this.idCounter, projectRole.getName(), projectRole.getDescription());
        this.addRole(projectRole);
        return role;
    }

    public boolean isRoleNameUnique(String name) {
        try {
            this.checkRoleNameUnique(name);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void checkRoleNameUnique(String name) {
        Iterator<ProjectRole> iterator = this.getProjectRoles().iterator();
        while (iterator.hasNext()) {
            ProjectRole o;
            ProjectRole role = o = iterator.next();
            if (name == null || !name.equals(role.getName())) continue;
            throw new IllegalArgumentException("Cannot have two roles with the same name");
        }
    }

    public void deleteRole(ProjectRole projectRole) {
        this.projectRoles.remove(projectRole);
    }

    public void updateRole(ProjectRole projectRole) {
        this.projectRoles.remove(projectRole);
        this.projectRoles.add(projectRole);
    }

    public ProjectRoleActors getProjectRoleActors(ProjectRole projectRole, Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Mock bad argument");
        }
        HashSet actors = Sets.newHashSet();
        HashSet users = Sets.newHashSet();
        users.add(new MockApplicationUser("tester", "tester", "tester@test.com"));
        users.add(new MockApplicationUser("fred", "fred", "fred@test.com"));
        Long roleId = projectRole.getId();
        Long projectId = project.getId();
        try {
            actors.add(new MockRoleActor(1L, roleId, projectId, users, "mock type", "tester"));
            actors.add(new MockRoleActor(2L, roleId, projectId, users, "mock type", "fred"));
        }
        catch (RoleActorDoesNotExistException e) {
            throw new RuntimeException(e);
        }
        return new ProjectRoleActorsImpl(projectId, roleId, (Set)actors);
    }

    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) {
    }

    public DefaultRoleActors getDefaultRoleActors(ProjectRole projectRole) {
        HashSet actors = Sets.newHashSet();
        HashSet users = Sets.newHashSet();
        users.add(new MockApplicationUser("tester", "tester", "tester@test.com"));
        try {
            actors.add(new MockRoleActor(1L, projectRole.getId(), null, users, "mock type", "tester"));
        }
        catch (RoleActorDoesNotExistException e) {
            throw new RuntimeException(e);
        }
        return new DefaultRoleActorsImpl(projectRole.getId(), (Set)actors);
    }

    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) {
    }

    public void applyDefaultsRolesToProject(Project project) {
    }

    public void removeAllRoleActorsByNameAndType(String name, String type) {
    }

    public void removeAllRoleActorsByProject(Project project) {
    }

    public boolean isUserInProjectRole(ApplicationUser user, ProjectRole projectRole, Project project) {
        return false;
    }

    public Collection<Long> getProjectIdsContainingRoleActorByNameAndType(String name, String type) {
        return Collections.emptyList();
    }

    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) {
        return null;
    }

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userName) {
        return null;
    }

    @Deprecated
    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap createProjectIdToProjectRolesMap(ApplicationUser user, Collection<Long> projectIds) {
        ProjectRoleManager.ProjectIdToProjectRoleIdsMap map = new ProjectRoleManager.ProjectIdToProjectRoleIdsMap();
        if (projectIds != null && !projectIds.isEmpty()) {
            ProjectManager projectManager = ComponentAccessor.getProjectManager();
            for (Long projectId : projectIds) {
                Collection<ProjectRole> projectRoles = this.getProjectRoles(user, projectManager.getProjectObj(projectId));
                Iterator<ProjectRole> iterator = projectRoles.iterator();
                while (iterator.hasNext()) {
                    ProjectRole projectRole1;
                    ProjectRole projectRole = projectRole1 = iterator.next();
                    map.add(projectId, projectRole.getId());
                }
            }
        }
        return map;
    }

    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap createProjectIdToProjectRolesMapWithGroups(@Nonnull ApplicationUser user, @Nonnull Set<String> groups) {
        return null;
    }

    public static class MockRoleActorFactory
    implements RoleActorFactory {
        public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String parameter) throws RoleActorDoesNotExistException {
            return new MockRoleActor(id, projectRoleId, projectId, Collections.emptySet(), type, parameter);
        }

        public Set<RoleActor> optimizeRoleActorSet(Set<RoleActor> roleActors) {
            return roleActors;
        }

        @Nonnull
        public Set<ProjectRoleActor> getAllRoleActorsForUser(@Nullable ApplicationUser user) {
            return Collections.emptySet();
        }
    }

    public static class MockRoleActor
    implements ProjectRoleActor {
        private Long projectRoleId;
        private Long projectId;
        private Set<ApplicationUser> users;
        private String type;
        private Long id;
        private String parameter;
        public static final String INVALID_PARAMETER = "Invalid Parameter";
        public static final String TYPE = "mock type";

        public MockRoleActor(Long id, Long projectRoleId, Long projectId, Set<ApplicationUser> users, String type, String parameter) throws RoleActorDoesNotExistException {
            this.id = id;
            this.projectId = projectId;
            this.projectRoleId = projectRoleId;
            this.users = users;
            this.type = type;
            this.setParameter(parameter);
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getProjectRoleId() {
            return this.projectRoleId;
        }

        public void setProjectRoleId(Long projectRoleId) {
            this.projectRoleId = projectRoleId;
        }

        public Long getProjectId() {
            return this.projectId;
        }

        public void setProjectId(Long projectId) {
            this.projectId = projectId;
        }

        public String getPrettyName() {
            return "Mock Role Actor";
        }

        public String getDescriptor() {
            return this.type + ':' + this.parameter;
        }

        public String getType() {
            return this.type;
        }

        public String getParameter() {
            return this.parameter;
        }

        public Set<ApplicationUser> getUsers() {
            return this.users;
        }

        public void setParameter(String parameter) throws RoleActorDoesNotExistException {
            if (INVALID_PARAMETER.equals(parameter)) {
                throw new RoleActorDoesNotExistException("Invalid Param does not exist");
            }
            this.parameter = parameter;
        }

        public boolean contains(ApplicationUser user) {
            return this.users.contains(user);
        }

        public boolean isActive() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockRoleActor that = (MockRoleActor)o;
            return this.parameter.equals(that.parameter) && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 29 * result + this.parameter.hashCode();
            return result;
        }

        public String toString() {
            return "MockRoleActor[descriptor=" + this.getDescriptor() + ']';
        }
    }

    public static class MockProjectRole
    implements ProjectRole {
        private String name;
        private String description;
        private Long id;

        public MockProjectRole(long id, String name, String description) {
            this.name = name;
            this.description = description;
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            return "Project Role: " + this.name + '(' + this.id + ')';
        }
    }
}

