/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.appconsistency;

import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.appconsistency.integrity.integritycheck.ProgressAwareIntegrityCheckerOperation;
import com.atlassian.jira.task.context.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockIntegrityCheckerOperation
implements ProgressAwareIntegrityCheckerOperation {
    public static final Long CHECK_ID_CAUSING_INTEGRITY_EXCEPTION = 1L;
    private static final String OPERATION_DESCRIPTION_KEY = "";

    public String getOperationName() {
        return "MockedIntegrityCheckerOperation";
    }

    public String getOperationDescription() {
        return "Description of the mocked integrity checker operation.";
    }

    public String getOperationProgressKey() {
        return OPERATION_DESCRIPTION_KEY;
    }

    public Map<Long, List<Amendment>> perform(List<Long> checks, Context taskContext) throws IntegrityException {
        HashMap<Long, List<Amendment>> results = new HashMap<Long, List<Amendment>>();
        if (checks != null && !checks.isEmpty()) {
            if (checks.contains(CHECK_ID_CAUSING_INTEGRITY_EXCEPTION)) {
                throw new IntegrityException();
            }
            for (Long check : checks) {
                results.put(check, new ArrayList());
            }
        }
        return results;
    }
}

