/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.ofbiz;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.mock.ofbiz.MockOfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilValidate;

public class MockGenericValue
extends GenericValue {
    protected boolean created = false;
    protected boolean stored = false;
    protected boolean refreshed = false;
    protected boolean removed = false;
    Map<String, List<GenericValue>> related = Maps.newHashMap();
    private Map<String, FieldType> fieldTypes = new HashMap<String, FieldType>();
    GenericDelegator gd;
    OfBizDelegator ofBizDelegator = null;

    public MockGenericValue(GenericValue value) {
        this(value.getEntityName());
        this.fields = value.getFields(value.getAllKeys());
    }

    public MockGenericValue(String entityName) {
        super(new ModelEntity(), null);
        this.entityName = entityName;
        this.modelEntity = new MockModelEntity(this);
        this.fields = Maps.newHashMap();
    }

    public MockGenericValue(String entityName, Map<String, ?> fields) {
        this(entityName);
        if (fields != null) {
            this.fields = Maps.newHashMap(fields);
        }
    }

    public MockGenericValue(@Nonnull String entityName, @Nonnull Map<String, ?> fields, @Nonnull Map<String, FieldType> fieldTypes) {
        this(entityName, fields);
        this.fieldTypes = fieldTypes;
    }

    public MockGenericValue(String entityName, Long id) {
        this(entityName, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public MockGenericValue(String entityName, ModelEntity modelEntity, Map<String, Object> fields) {
        super(modelEntity, null);
        this.entityName = entityName;
        this.fields = fields != null ? fields : new HashMap();
    }

    public Object get(String name) {
        return this.fields.get(name);
    }

    public void set(String name, Object value) {
        this.fields.put(name, value);
    }

    public Collection<String> getAllKeys() {
        return this.fields.keySet();
    }

    public Map<String, Object> getFields(Collection<String> collection) {
        HashMap<String, Object> selectedFields = new HashMap<String, Object>();
        for (String key : collection) {
            selectedFields.put(key, this.fields.get(key));
        }
        return selectedFields;
    }

    public synchronized void setFields(Map<? extends String, ?> keyValuePairs) {
        if (keyValuePairs == null) {
            this.fields = Maps.newHashMap();
        } else {
            Object id = this.get("id");
            this.fields = Maps.newHashMap(keyValuePairs);
            if (!keyValuePairs.containsKey("id") && id != null) {
                this.set("id", id);
            }
        }
    }

    public Map<String, Object> getAllFields() {
        return this.fields;
    }

    public List<GenericValue> getRelated(String s) throws GenericEntityException {
        List<GenericValue> related = this.related.get(s);
        return related != null ? related : Collections.emptyList();
    }

    public GenericValue getRelatedOne(String s) throws GenericEntityException {
        List<GenericValue> related = this.related.get(s);
        return related != null && related.size() > 0 ? related.get(0) : null;
    }

    public List<GenericValue> getRelated(String s, Map<String, ?> map, List<String> order) throws GenericEntityException {
        return CoreFactory.getGenericDelegator().getRelated(s, map, order, (GenericValue)this);
    }

    public void setRelated(String s, List<GenericValue> relatedGVs) {
        this.related.put(s, relatedGVs);
    }

    public GenericValue create() throws GenericEntityException {
        if (this.ofBizDelegator != null) {
            this.ofBizDelegator.createValue(this.entityName, this.fields);
        }
        this.created = true;
        return this;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isStored() {
        return this.stored;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public ModelEntity getModelEntity() {
        ModelEntity result = super.getModelEntity();
        return result != null ? result : new MockModelEntity(this);
    }

    public boolean matchesFields(Map<String, ?> keyValuePairs) {
        if (this.fields == null) {
            return true;
        }
        if (keyValuePairs == null || keyValuePairs.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, ?> entry : keyValuePairs.entrySet()) {
            if (UtilValidate.areEqual(entry.getValue(), this.fields.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public GenericPK getPrimaryKey() {
        return new GenericPK(this.getModelEntity(), UtilMisc.toMap((String)"id", this.fields.get("id")));
    }

    public void setDelegator(GenericDelegator internalDelegator) {
        this.gd = internalDelegator;
    }

    public GenericDelegator getDelegator() {
        return this.gd;
    }

    public void store() throws GenericEntityException {
        this.stored = true;
        if (this.ofBizDelegator instanceof MockOfBizDelegator) {
            this.ofBizDelegator.store((GenericValue)this);
        } else {
            CoreFactory.getGenericDelegator().store((GenericValue)this);
        }
    }

    public void remove() throws GenericEntityException {
        this.removed = true;
        if (this.ofBizDelegator instanceof MockOfBizDelegator) {
            this.ofBizDelegator.removeValue((GenericValue)this);
        } else {
            CoreFactory.getGenericDelegator().removeValue((GenericValue)this);
        }
    }

    public void removeRelated(String relationName) throws GenericEntityException {
        this.related.remove(relationName);
    }

    public void refresh() throws GenericEntityException {
        this.refreshed = true;
        CoreFactory.getGenericDelegator().refresh((GenericValue)this);
    }

    public String toString() {
        StringBuilder theString = new StringBuilder();
        theString.append("[GenericEntity:");
        theString.append(this.getEntityName());
        theString.append(']');
        for (Map.Entry anEntry : this.fields.entrySet()) {
            theString.append('[');
            theString.append(anEntry.getKey());
            theString.append(',');
            theString.append(anEntry.getValue());
            theString.append(']');
        }
        return theString.toString();
    }

    public Object dangerousGetNoCheckButFast(ModelField modelField) {
        if (modelField == null) {
            throw new IllegalArgumentException("Cannot get field with a null modelField");
        }
        return this.fields.get(modelField.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockGenericValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MockGenericValue mockGenericValue = (MockGenericValue)((Object)o);
        return !(this.fields != null ? !this.fields.equals(mockGenericValue.fields) : mockGenericValue.fields != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.fields != null ? this.fields.hashCode() : 0);
        result = 29 * result + (this.created ? 1 : 0);
        return result;
    }

    public void setString(String name, String value) {
        FieldType fieldType = this.fieldTypes.get(name);
        this.set(name, fieldType != null ? fieldType.parseFunction.apply(value) : value);
    }

    public List<GenericValue> getRelatedOrderBy(String relationName, List<String> orderBy) throws GenericEntityException {
        return CoreFactory.getGenericDelegator().getRelatedOrderBy(relationName, orderBy, (GenericValue)this);
    }

    public List<GenericValue> getRelatedByAnd(String relationName, Map<String, ?> fields) throws GenericEntityException {
        return CoreFactory.getGenericDelegator().getRelatedByAnd(relationName, fields, (GenericValue)this);
    }

    @Nonnull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.fields.entrySet();
    }

    @Nonnull
    public Set<String> keySet() {
        return this.fields.keySet();
    }

    public int size() {
        return this.fields.size();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public Collection<Object> values() {
        return this.fields.values();
    }

    public Object clone() {
        MockGenericValue result = new MockGenericValue(this.entityName, Maps.newHashMap((Map)this.fields));
        result.related.putAll(this.related);
        result.setOfBizDelegator(this.ofBizDelegator);
        return result;
    }

    public void setOfBizDelegator(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public static enum FieldType {
        STRING("string", t -> t),
        INT("int", Integer::valueOf),
        LONG("long", Long::valueOf);

        final String type;
        final Function<String, Object> parseFunction;

        private FieldType(String type, Function<String, Object> parseFunction) {
            this.type = type;
            this.parseFunction = parseFunction;
        }

        String getType() {
            return this.type;
        }
    }

    public class MockModelEntity
    extends ModelEntity {
        MockGenericValue value;

        public MockModelEntity() {
        }

        public MockModelEntity(MockGenericValue value) {
            this.value = value;
            this.setEntityName(value.getEntityName());
        }

        public List<String> getAllFieldNames() {
            return Lists.newArrayList(this.value.getAllKeys());
        }

        public ModelField getField(String fieldName) {
            ModelField field = super.getField(fieldName);
            if (field == null && this.value.getAllKeys().contains(fieldName)) {
                field = new ModelField(fieldName, MockGenericValue.this.fieldTypes.getOrDefault(fieldName, FieldType.STRING).getType(), null, false, null);
            }
            return field;
        }

        public Iterator<ModelField> getFieldsIterator() {
            return Iterables.transform(this.getAllFieldNames(), name -> new ModelField(name, MockGenericValue.this.fieldTypes.getOrDefault(name, FieldType.STRING).getType(), null, false, null)).iterator();
        }
    }
}

