/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.ofbiz;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.mock.ofbiz.MockGenericValue;
import com.atlassian.jira.mock.ofbiz.MockOfBizListIterator;
import com.atlassian.jira.mock.ofbiz.ModelReaderMock;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.EntityWhereString;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericEntityNotFoundException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.Transformation;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;

public class MockOfBizDelegator
implements OfBizDelegator {
    public static final int STARTING_ID = 1000;
    public static final Comparator<GenericValue> GV_ENTITY_NAME_AND_ID_COMPARATOR = new Comparator<GenericValue>(){

        @Override
        public int compare(GenericValue lhs, GenericValue rhs) {
            int result;
            String lhsEntityName = lhs.getEntityName();
            String rhsEntityName = rhs.getEntityName();
            int n = lhsEntityName == null || rhsEntityName == null ? (lhsEntityName == null && rhsEntityName == null ? 0 : -1) : (result = lhsEntityName.compareTo(rhsEntityName));
            if (result != 0) {
                return result;
            }
            Long lhsId = lhs.getLong("id");
            Long rhsId = rhs.getLong("id");
            return lhsId == null || rhsId == null ? (lhsId == null && rhsId == null ? 0 : -1) : lhsId.compareTo(rhsId);
        }
    };
    private ModelReader modelReader = ModelReaderMock.getMock();
    private final List<GenericValue> genericValues;
    private final List<GenericValue> expectedGenericValues;
    private final Map<RelatedKey, List<GenericValue>> relatedMap = Maps.newHashMap();
    private DelegatorInterface delegatorInterface;
    private long ids = 1000L;

    public MockOfBizDelegator() {
        this(null, null);
    }

    public MockOfBizDelegator(List<? extends GenericValue> genericValues, List<? extends GenericValue> expectedGenericValues) {
        this.genericValues = genericValues != null ? Lists.newArrayList(genericValues) : Lists.newArrayList();
        this.expectedGenericValues = expectedGenericValues != null ? Collections.unmodifiableList(expectedGenericValues) : Collections.emptyList();
        for (GenericValue genericValue : this.genericValues) {
            if (!(genericValue instanceof MockGenericValue)) continue;
            ((MockGenericValue)genericValue).setOfBizDelegator(this);
        }
        for (GenericValue expectedGenericValue : this.expectedGenericValues) {
            if (!(expectedGenericValue instanceof MockGenericValue)) continue;
            ((MockGenericValue)expectedGenericValue).setOfBizDelegator(this);
        }
    }

    public MockOfBizDelegator(DelegatorInterface delegatorInterface) {
        this(null, null);
        this.delegatorInterface = delegatorInterface;
    }

    public List<GenericValue> findByField(String entityName, String fieldName, Object fieldValue) {
        return this.findByAnd(entityName, (Map<String, ?>)new FieldMap(fieldName, fieldValue));
    }

    public List<GenericValue> findByField(String entityName, String fieldName, Object fieldValue, String orderBy) {
        return this.findByAnd(entityName, (Map<String, ?>)new FieldMap(fieldName, fieldValue), CollectionBuilder.list((Object[])new String[]{orderBy}));
    }

    public synchronized void setGenericValues(List<? extends GenericValue> genericValues) {
        this.genericValues.clear();
        this.genericValues.addAll(genericValues);
    }

    public List<GenericValue> findByAnd(String s, Map<String, ?> map) throws DataAccessException {
        return EntityUtil.filterByAnd(this.findAll(s), map);
    }

    public List<GenericValue> findByAnd(String s, Map<String, ?> map, List<String> orderClause) throws DataAccessException {
        List<GenericValue> values = this.findByAnd(s, map);
        if (!orderClause.isEmpty()) {
            return EntityUtil.orderBy(values, orderClause);
        }
        return values;
    }

    public List<GenericValue> findByAnd(String s, List<EntityCondition> expressions) throws DataAccessException {
        ArrayList exprs = Lists.newArrayList();
        for (EntityCondition condition : expressions) {
            exprs.add((EntityExpr)condition);
        }
        return EntityUtil.filterByAnd(this.findAll(s), (List)exprs);
    }

    public List<GenericValue> findByOr(String entityName, List<? extends EntityCondition> expressions, List<String> orderBy) throws DataAccessException {
        return this.findByCondition(entityName, (EntityCondition)new EntityConditionList(expressions, EntityOperator.OR), null, orderBy);
    }

    public List<GenericValue> findByLike(String entityName, Map<String, ?> map, List<String> orderBy) throws DataAccessException {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            list.add(new EntityExpr(entry.getKey(), EntityOperator.LIKE, entry.getValue()));
        }
        EntityConditionList condition = new EntityConditionList((List)list, EntityOperator.AND);
        return this.findByCondition(entityName, (EntityCondition)condition, orderBy);
    }

    public List<GenericValue> findByLike(String entityName, Map<String, ?> map) throws DataAccessException {
        return this.findByLike(entityName, map, null);
    }

    public synchronized void removeAll(List<GenericValue> genericValues) throws DataAccessException {
        TreeSet<GenericValue> toRemove = new TreeSet<GenericValue>(GV_ENTITY_NAME_AND_ID_COMPARATOR);
        toRemove.addAll(genericValues);
        Iterator<GenericValue> localStorageIterator = this.genericValues.iterator();
        while (localStorageIterator.hasNext()) {
            if (!toRemove.contains(localStorageIterator.next())) continue;
            localStorageIterator.remove();
        }
    }

    public synchronized int removeByAnd(String s, Map<String, ?> map) throws DataAccessException {
        List<GenericValue> matching = this.findByAnd(s, map);
        this.removeAll(matching);
        return matching.size();
    }

    public int removeByCondition(String entityName, EntityCondition condition) throws DataAccessException {
        List<GenericValue> matching = this.findByCondition(entityName, condition, null);
        this.removeAll(matching);
        return matching.size();
    }

    public int removeById(String entityName, Long id) {
        return this.removeByAnd(entityName, (Map<String, ?>)FieldMap.build((String)"id", (Object)id));
    }

    public int removeValue(GenericValue value) {
        this.removeAll(Collections.singletonList(value));
        return 1;
    }

    public synchronized void storeAll(List<GenericValue> genericValues) throws DataAccessException {
        ArrayList<GenericValue> fixed = new ArrayList<GenericValue>(genericValues.size());
        for (GenericValue newValue : genericValues) {
            Iterator<GenericValue> iterator = this.genericValues.iterator();
            while (iterator.hasNext()) {
                GenericValue oldValue = iterator.next();
                if (!oldValue.getLong("id").equals(newValue.getLong("id")) || !oldValue.getEntityName().equals(newValue.getEntityName())) continue;
                iterator.remove();
                oldValue.putAll((Map)newValue);
                newValue = oldValue;
                break;
            }
            fixed.add(newValue);
        }
        this.genericValues.addAll(fixed);
    }

    public synchronized List<GenericValue> findAll(String s) {
        return (List)this.genericValues.stream().filter(value -> s.equals(value.getEntityName())).map(value -> (GenericValue)value.clone()).collect(CollectorsUtil.toNewArrayListWithSizeOf(this.genericValues));
    }

    public List<GenericValue> findAll(String s, List<String> sortOrder) throws DataAccessException {
        return this.filterByOrderBy(this.findAll(s), sortOrder);
    }

    public void store(GenericValue gv) throws DataAccessException {
        Object id = gv.get("id");
        GenericValue currentValue = this.findByPrimaryKey(gv.getEntityName(), (Map<String, ?>)FieldMap.build((String)"id", (Object)id));
        if (currentValue == null) {
            throw new DataAccessException((Throwable)new GenericEntityNotFoundException("Tried to update an entity that does not exist"));
        }
        this.genericValues.remove(currentValue);
        for (Map.Entry entry : gv.entrySet()) {
            currentValue.set((String)entry.getKey(), entry.getValue());
        }
        this.genericValues.add(currentValue);
    }

    public void createValue(GenericValue entity) {
        this.genericValues.add(entity);
    }

    public synchronized GenericValue createValue(String entity, Map<String, Object> params) throws DataAccessException {
        HashMap<String, Object> fields = new HashMap<String, Object>(params);
        if (fields.get("id") == null) {
            fields.put("id", this.ids++);
        }
        GenericValue gv = this.makeValue(entity, fields);
        this.genericValues.add(gv);
        return gv;
    }

    public void createValueWithoutId(String entityName, Map<String, Object> fields) {
        GenericValue gv = this.makeValue(entityName, fields);
        this.genericValues.add(gv);
    }

    public GenericValue makeValue(String entity) {
        return this.makeValue(entity, null);
    }

    public GenericValue makeValue(String entityName, Map<String, Object> fields) {
        ModelEntity modelEntity;
        try {
            modelEntity = this.getModelReader().getModelEntity(entityName);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        MockGenericValue genericValue = modelEntity != null ? new MockGenericValue(entityName, modelEntity, fields) : new MockGenericValue(entityName, fields);
        genericValue.setOfBizDelegator(this);
        return genericValue;
    }

    public GenericValue findById(String entityName, Long id) throws DataAccessException {
        return this.findByPrimaryKey(entityName, id);
    }

    public GenericValue findByPrimaryKey(String entityName, Long id) {
        return this.findByPrimaryKey(entityName, (Map<String, ?>)FieldMap.build((String)"id", (Object)id));
    }

    public GenericValue findByPrimaryKey(String s, Map<String, ?> map) {
        GenericValue result = EntityUtil.getOnly(this.findByAnd(s, map));
        return result != null ? (GenericValue)result.clone() : null;
    }

    public List<GenericValue> getRelated(String relationName, GenericValue gv) {
        RelatedKey key = new RelatedKey(gv, relationName);
        if (this.relatedMap.containsKey(key)) {
            return this.relatedMap.get(key);
        }
        RelationDefinition relationDefinition = this.getRelationDefinition(relationName);
        if (relationDefinition == null) {
            return Lists.newArrayList();
        }
        return this.findByAnd(relationDefinition.relatedEntityName, (Map<String, ?>)new FieldMap(relationDefinition.relatedFieldName, gv.get(relationDefinition.fieldName)));
    }

    private RelationDefinition getRelationDefinition(String relationName) {
        if (relationName.equals("ChildSchemePermissions")) {
            return new RelationDefinition("SchemePermissions", "id", "scheme");
        }
        if (relationName.equals("ChildNotification")) {
            return new RelationDefinition("Notification", "id", "scheme");
        }
        return null;
    }

    public List<GenericValue> getRelated(String relationName, GenericValue gv, List<String> orderBy) {
        return this.getRelated(relationName, gv);
    }

    public long getCount(String entityName) {
        return this.findAll(entityName).size();
    }

    public long getCountByAnd(String entityName, EntityCondition condition) {
        return this.findByAnd(entityName, (List<EntityCondition>)ImmutableList.of((Object)condition)).size();
    }

    public long getCountByAnd(String entityName, Map<String, ?> fields) {
        return this.findByAnd(entityName, fields).size();
    }

    public OfBizListIterator findListIteratorByCondition(String entityType, EntityCondition condition) {
        List<GenericValue> results = this.findAll(entityType);
        results = this.filterByEntityCondition(results, condition);
        return new MockOfBizListIterator(results);
    }

    public OfBizListIterator findListIteratorByCondition(String entityName, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection<String> fieldsToSelect, List<String> orderBy, EntityFindOptions entityFindOptions) {
        List<GenericValue> results = this.findAll(entityName);
        results = this.filterByEntityCondition(results, whereEntityCondition);
        results = this.filterByOrderBy(results, orderBy);
        results = this.filterByFieldsToSelect(results, fieldsToSelect);
        results = this.filterByFindOptions(results, entityFindOptions);
        return new MockOfBizListIterator(results);
    }

    private List<GenericValue> filterByFieldsToSelect(List<GenericValue> values, Collection<String> fieldsToSelect) {
        if (fieldsToSelect == null || fieldsToSelect.isEmpty()) {
            return values;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>(values.size());
        for (GenericValue value : values) {
            MockGenericValue copy = new MockGenericValue(value);
            copy.setOfBizDelegator(this);
            copy.keySet().retainAll(fieldsToSelect);
            result.add(copy);
        }
        return result;
    }

    private List<GenericValue> filterByOrderBy(List<GenericValue> allValues, List<String> orderBy) {
        return orderBy == null || orderBy.isEmpty() ? allValues : EntityUtil.orderBy(allValues, orderBy);
    }

    private List<GenericValue> filterByFindOptions(List<GenericValue> values, EntityFindOptions options) {
        if (options != null) {
            if (options.getDistinct()) {
                values = this.filterDistinct(values);
            }
            if (options.getMaxResults() > 0) {
                values = this.filterRange(values, options.getOffset(), options.getMaxResults());
            }
        }
        return values;
    }

    private List<GenericValue> filterDistinct(List<GenericValue> values) {
        ArrayList<GenericValue> result = new ArrayList<GenericValue>(values.size());
        HashSet<GenericValue> seen = new HashSet<GenericValue>();
        for (GenericValue value : values) {
            if (!seen.add(value)) continue;
            result.add(value);
        }
        return result;
    }

    private List<GenericValue> filterRange(List<GenericValue> values, int offset, int maxResults) {
        if (offset >= values.size()) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(values.subList(offset, Math.min(values.size(), offset + maxResults)));
    }

    private List<GenericValue> filterByEntityCondition(List<GenericValue> allValues, EntityCondition entityCondition) {
        if (entityCondition == null) {
            return allValues;
        }
        return Lists.newArrayList((Iterable)Iterables.filter(allValues, this.getPredicateFor(entityCondition)));
    }

    private Predicate<GenericValue> getPredicateFor(EntityCondition entityCondition) {
        if (entityCondition instanceof EntityFieldMap) {
            return this.getPredicateForEntityFieldMap((EntityFieldMap)entityCondition);
        }
        if (entityCondition instanceof EntityExpr) {
            return this.getPredicateForEntityExpr((EntityExpr)entityCondition);
        }
        if (entityCondition instanceof EntityConditionList) {
            return this.getPredicateForEntityConditionList((EntityConditionList)entityCondition);
        }
        if (entityCondition instanceof EntityWhereString && StringUtils.isEmpty((CharSequence)entityCondition.makeWhereString(null, null, null))) {
            return Predicates.alwaysTrue();
        }
        if (entityCondition instanceof EntityExprList) {
            return this.getPredicateForEntityExprList((EntityExprList)entityCondition);
        }
        throw new UnsupportedOperationException("Mock cannot yet handle EntityCondition of type " + entityCondition.getClass());
    }

    private Predicate<GenericValue> getPredicateForEntityExprList(EntityExprList exprList) {
        ArrayList children = Lists.newArrayListWithCapacity((int)exprList.getExprListSize());
        Iterator iter = exprList.getExprIterator();
        while (iter.hasNext()) {
            children.add(this.getPredicateForEntityExpr((EntityExpr)iter.next()));
        }
        if (exprList.getOperator().equals((Object)EntityOperator.AND)) {
            return Predicates.and((Iterable)children);
        }
        if (exprList.getOperator().equals((Object)EntityOperator.OR)) {
            return Predicates.or((Iterable)children);
        }
        throw new UnsupportedOperationException("Mock cannot yet handle EntityExprList with operator " + exprList.getOperator());
    }

    private Predicate<GenericValue> getPredicateForEntityConditionList(EntityConditionList conditionList) {
        ArrayList conditions = Lists.newArrayListWithCapacity((int)conditionList.getConditionListSize());
        Iterator iter = conditionList.getConditionIterator();
        while (iter.hasNext()) {
            conditions.add(this.getPredicateFor((EntityCondition)iter.next()));
        }
        if (conditionList.getOperator().equals((Object)EntityOperator.AND)) {
            return Predicates.and((Iterable)conditions);
        }
        if (conditionList.getOperator().equals((Object)EntityOperator.OR)) {
            return Predicates.or((Iterable)conditions);
        }
        throw new UnsupportedOperationException("Mock cannot yet handle EntityConditionList with operator " + conditionList.getOperator());
    }

    private Predicate<GenericValue> getPredicateForEntityFieldMap(EntityFieldMap entityFieldMap) {
        if (entityFieldMap.getOperator().getId() == 10) {
            return gv -> !Iterators.any((Iterator)entityFieldMap.getFieldKeyIterator(), fieldName -> !Objects.equal((Object)entityFieldMap.getField(fieldName), (Object)gv.get(fieldName)));
        }
        if (entityFieldMap.getOperator().getId() == 11) {
            return gv -> Iterators.any((Iterator)entityFieldMap.getFieldKeyIterator(), fieldName -> Objects.equal((Object)entityFieldMap.getField(fieldName), (Object)gv.get(fieldName)));
        }
        throw new IllegalStateException("I don't like the operator " + entityFieldMap.getOperator());
    }

    private Predicate<GenericValue> getPredicateForEntityExpr(final EntityExpr expr) {
        switch (expr.getOperator().getId()) {
            case 1: {
                return new Predicate<GenericValue>(){
                    private final Object rhs;
                    {
                        this.rhs = MockOfBizDelegator.rhs(expr);
                    }

                    public boolean apply(GenericValue input) {
                        return Objects.equal((Object)MockOfBizDelegator.lhs(input, expr), (Object)this.rhs);
                    }
                };
            }
            case 2: {
                return new Predicate<GenericValue>(){
                    private final Object rhs;
                    {
                        this.rhs = MockOfBizDelegator.rhs(expr);
                    }

                    public boolean apply(GenericValue input) {
                        return !Objects.equal((Object)MockOfBizDelegator.lhs(input, expr), (Object)this.rhs);
                    }
                };
            }
            case 5: {
                return new Predicate<GenericValue>(){
                    private final Object rhs;
                    {
                        this.rhs = MockOfBizDelegator.rhs(expr);
                    }

                    public boolean apply(GenericValue input) {
                        if (this.rhs instanceof Number) {
                            return ((Number)MockOfBizDelegator.lhs(input, expr)).longValue() <= ((Number)this.rhs).longValue();
                        }
                        if (this.rhs instanceof Date) {
                            return ((Date)MockOfBizDelegator.lhs(input, expr)).getTime() <= ((Date)this.rhs).getTime();
                        }
                        throw new UnsupportedOperationException("I don't know how to <= on a " + this.rhs.getClass().getName());
                    }
                };
            }
            case 4: {
                return new Predicate<GenericValue>(){

                    public boolean apply(GenericValue input) {
                        Object lhs = MockOfBizDelegator.lhs(input, expr);
                        if (lhs == null) {
                            return false;
                        }
                        Object rhs = MockOfBizDelegator.rhs(expr);
                        if (rhs instanceof Date) {
                            return ((Date)lhs).getTime() > ((Date)rhs).getTime();
                        }
                        if (rhs instanceof Number) {
                            return ((Number)lhs).longValue() > ((Number)rhs).longValue();
                        }
                        throw new UnsupportedOperationException("Cannot use > on a " + rhs.getClass().getName());
                    }
                };
            }
            case 6: {
                return input -> {
                    Object lhs = MockOfBizDelegator.lhs(input, expr);
                    if (lhs == null) {
                        return false;
                    }
                    Object rhs = MockOfBizDelegator.rhs(expr);
                    if (rhs instanceof Date) {
                        return ((Date)lhs).getTime() >= ((Date)rhs).getTime();
                    }
                    if (rhs instanceof Number) {
                        return ((Number)lhs).longValue() >= ((Number)rhs).longValue();
                    }
                    throw new UnsupportedOperationException("Cannot use <= on a " + rhs.getClass().getName());
                };
            }
            case 12: {
                return new Predicate<GenericValue>(){
                    private final Pattern rhs;
                    {
                        this.rhs = MockOfBizDelegator.compileLike((String)MockOfBizDelegator.rhs(expr));
                    }

                    public boolean apply(GenericValue input) {
                        String lhs = (String)MockOfBizDelegator.lhs(input, expr);
                        return lhs != null && this.rhs.matcher(lhs).matches();
                    }
                };
            }
            case 7: {
                return new Predicate<GenericValue>(){
                    private final Collection<?> rhs;
                    {
                        this.rhs = (Collection)MockOfBizDelegator.rhs(expr);
                    }

                    public boolean apply(GenericValue input) {
                        return this.rhs.contains(MockOfBizDelegator.lhs(input, expr));
                    }
                };
            }
            case 10: {
                return new Predicate<GenericValue>(){
                    Predicate<GenericValue> predicate1;
                    Predicate<GenericValue> predicate2;
                    {
                        this.predicate1 = MockOfBizDelegator.this.getPredicateFor((EntityCondition)expr.getLhs());
                        this.predicate2 = MockOfBizDelegator.this.getPredicateFor((EntityCondition)expr.getRhs());
                    }

                    public boolean apply(GenericValue input) {
                        return this.predicate1.apply((Object)input) && this.predicate2.apply((Object)input);
                    }
                };
            }
            case 3: {
                return input -> {
                    Object field = MockOfBizDelegator.lhs(input, expr);
                    Object value = MockOfBizDelegator.rhs(expr);
                    if (field instanceof Comparable && value instanceof Comparable) {
                        return ((Comparable)field).compareTo(value) < 0;
                    }
                    throw new UnsupportedOperationException("Objects have to be comparable");
                };
            }
        }
        throw new UnsupportedOperationException("Can't deal with " + expr.getOperator() + " yet.");
    }

    static Pattern compileLike(String regex) {
        StringBuilder sb = new StringBuilder(regex.length() + 64).append('^');
        block5: for (int i = 0; i < regex.length(); ++i) {
            char c = regex.charAt(i);
            switch (c) {
                case '_': {
                    sb.append('.');
                    continue block5;
                }
                case '%': {
                    sb.append(".*");
                    continue block5;
                }
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return Pattern.compile(sb.append('$').toString());
    }

    static Object lhs(GenericValue input, EntityExpr expr) {
        return MockOfBizDelegator.maybeUpper(input.get((String)expr.getLhs()), expr.isLUpper());
    }

    static Object rhs(EntityExpr expr) {
        return MockOfBizDelegator.maybeUpper(expr.getRhs(), expr.isLUpper());
    }

    static Object maybeUpper(Object in, boolean flag) {
        if (flag && in != null) {
            if (in instanceof String) {
                return ((String)in).toUpperCase();
            }
            throw new IllegalArgumentException("Why did we get an UPPER(xxx) request around class " + in.getClass().getName() + "?!");
        }
        return in;
    }

    private List<GenericValue> filterByAnd(List<GenericValue> values, EntityConditionList conditions) {
        Iterator iter = conditions.getConditionIterator();
        while (iter.hasNext()) {
            values = this.filterByEntityCondition(values, (EntityCondition)iter.next());
        }
        return values;
    }

    public int bulkUpdateByPrimaryKey(String entityName, Map<String, ?> updateValues, List<Long> keys) {
        int sum = 0;
        for (Long key : keys) {
            sum += this.bulkUpdateByAnd(entityName, updateValues, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)key));
        }
        return sum;
    }

    public int bulkUpdateByAnd(String entityName, Map<String, ?> updateValues, Map<String, ?> criteria) {
        List<GenericValue> results = this.findByAnd(entityName, criteria);
        for (GenericValue gv : results) {
            this.genericValues.remove(gv);
            for (Map.Entry<String, ?> updateEntry : updateValues.entrySet()) {
                gv.set(updateEntry.getKey(), updateEntry.getValue());
            }
            this.genericValues.add(gv);
        }
        return results.size();
    }

    public void verifyAll() throws AssertionError {
        this.verifyAll(this.expectedGenericValues);
    }

    public void verifyAll(GenericValue ... expectedGenericValues) {
        this.verifyAll(Arrays.asList(expectedGenericValues));
    }

    public void verifyAll(List<GenericValue> expectedGenericValues) throws AssertionError {
        Object[] expected = expectedGenericValues.toArray(new GenericValue[expectedGenericValues.size()]);
        Assert.assertThat(this.genericValues, (Matcher)Matchers.containsInAnyOrder((Object[])expected));
    }

    public void verify() throws AssertionError {
        this.verify(this.expectedGenericValues);
    }

    public void verify(GenericValue ... expectedGenericValues) {
        this.verify(Arrays.asList(expectedGenericValues));
    }

    public void verify(List<GenericValue> expectedGenericValues) {
        if (expectedGenericValues.size() != this.genericValues.size()) {
            throw new AssertionError((Object)("Expected: " + expectedGenericValues.size() + " genericValues, but there are " + this.genericValues.size() + ". Expected: " + expectedGenericValues + ", received " + this.genericValues));
        }
        for (GenericValue expectedValue : expectedGenericValues) {
            List<GenericValue> matchingValues = expectedValue.getLong("id") != null ? this.findByAnd(expectedValue.getEntityName(), (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)expectedValue.getLong("id"))) : this.findByAnd(expectedValue.getEntityName(), expectedValue.getFields(expectedValue.getAllKeys()));
            if (matchingValues == null || matchingValues.isEmpty()) {
                throw new AssertionError((Object)("Expected GenericValue " + expectedValue + " not found.  Found entities " + this.findAll(expectedValue.getEntityName())));
            }
            if (matchingValues.size() > 1) {
                throw new AssertionError((Object)("Multiple matches for GenericValue " + expectedValue.getEntityName() + " with id " + expectedValue.getLong("id")));
            }
            GenericValue receivedValue = EntityUtil.getOnly(matchingValues);
            this.assertFieldsMatch(expectedValue, receivedValue);
        }
    }

    private void assertFieldsMatch(GenericValue expectedValue, GenericValue receivedValue) {
        for (String fieldName : expectedValue.getAllKeys()) {
            Object receivedField = receivedValue.get(fieldName);
            Object expectedField = expectedValue.get(fieldName);
            if (!(receivedField == null && expectedField == null || receivedField != null && receivedField.equals(expectedField))) {
                throw new AssertionError((Object)("Expected '" + expectedField + "' for field '" + fieldName + "', but received '" + receivedField + "'.Expected GV: " + expectedValue + ". Received " + receivedValue));
            }
        }
    }

    public void addRelatedMap(String relationName, GenericValue gv, List<GenericValue> listToReturn) {
        ArrayList newRelations = Lists.newArrayList();
        RelatedKey key = new RelatedKey(gv, relationName);
        List<GenericValue> existingRelations = this.relatedMap.get(key);
        if (existingRelations != null) {
            newRelations.addAll(existingRelations);
        }
        newRelations.addAll(listToReturn);
        this.relatedMap.put(key, newRelations);
    }

    public void addRelatedMap(String relationName, GenericValue gv, GenericValue ... gvsToReturns) {
        this.addRelatedMap(relationName, gv, Arrays.asList(gvsToReturns));
    }

    public int removeByOr(String entityName, String entityId, List<Long> ids) {
        ArrayList<EntityExpr> expressions = new ArrayList<EntityExpr>();
        for (Long id : ids) {
            expressions.add(new EntityExpr(entityId, EntityOperator.EQUALS, (Object)id));
        }
        List<GenericValue> removees = this.findByOr(entityName, expressions, null);
        this.removeAll(removees);
        return removees.size();
    }

    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws DataAccessException {
        List<GenericValue> results = this.findAll(entityName);
        results = this.filterByEntityCondition(results, entityCondition);
        results = this.filterByOrderBy(results, orderBy);
        results = this.filterByFieldsToSelect(results, fieldsToSelect);
        return results;
    }

    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect) {
        return this.findByCondition(entityName, entityCondition, fieldsToSelect, null);
    }

    public ModelReader getModelReader() {
        return this.modelReader;
    }

    public void setModelReader(ModelReader modelReader) {
        this.modelReader = modelReader;
    }

    public void refreshSequencer() {
        throw new UnsupportedOperationException("Not mocked yet.");
    }

    public DelegatorInterface getDelegatorInterface() {
        if (this.delegatorInterface == null) {
            this.delegatorInterface = this.mockDelegatorInterface();
        }
        return this.delegatorInterface;
    }

    public boolean removeRelated(String relationName, GenericValue schemeGv) {
        List<GenericValue> remove = this.relatedMap.remove(new RelatedKey(schemeGv, relationName));
        if (remove != null) {
            this.removeAll(remove);
        }
        return remove != null;
    }

    public int bulkCopyColumnValuesByAnd(String entityName, Map updateColumns, Map criteria) {
        throw new UnsupportedOperationException("Not mocked yet.");
    }

    public synchronized List<GenericValue> transform(String entityName, EntityCondition entityCondition, List<String> orderBy, String lockField, Transformation transformation) {
        List<GenericValue> entities = this.findByCondition(entityName, entityCondition, null, orderBy);
        for (GenericValue entity : entities) {
            transformation.transform(entity);
            this.store(entity);
        }
        return entities;
    }

    public synchronized GenericValue transformOne(String entityName, EntityCondition entityCondition, String lockField, Transformation transformation) {
        List<GenericValue> transformedEntities = this.transform(entityName, entityCondition, null, lockField, transformation);
        if (transformedEntities.size() != 1) {
            throw new IllegalStateException("Expected one entity but found these: " + transformedEntities);
        }
        return transformedEntities.get(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.genericValues.size() * 256).append("MockOfBizDelegator[");
        if (!this.genericValues.isEmpty()) {
            for (GenericValue genericValue : this.genericValues) {
                sb.append("\n\t").append(genericValue).append(',');
            }
            sb.setCharAt(sb.length() - 1, '\n');
        }
        return sb.append(']').toString();
    }

    public void clear() {
        this.genericValues.clear();
        this.relatedMap.clear();
    }

    private DelegatorInterface mockDelegatorInterface() {
        try {
            return this.mockDelegatorInterfaceImpl();
        }
        catch (GenericEntityException gee) {
            throw new DataAccessException((Throwable)gee);
        }
    }

    private DelegatorInterface mockDelegatorInterfaceImpl() throws GenericEntityException {
        DelegatorInterface delegator = (DelegatorInterface)Mockito.mock(DelegatorInterface.class);
        Mockito.when((Object)delegator.getNextSeqId(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Long>(){
            private final AtomicLong counter = new AtomicLong(10000L);

            public Long answer(InvocationOnMock invocation) throws Throwable {
                return this.counter.getAndIncrement();
            }
        });
        Mockito.when((Object)delegator.countByCondition(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq(null), (EntityCondition)ArgumentMatchers.any(EntityCondition.class), (EntityFindOptions)ArgumentMatchers.any(EntityFindOptions.class))).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return MockOfBizDelegator.this.findByCondition((String)args[0], (EntityCondition)args[2], null, null).size();
            }
        });
        Mockito.when((Object)delegator.countByCondition((String)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (EntityCondition)ArgumentMatchers.any(), (EntityFindOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{new AssertionError((Object)"Counting by field not implemented")});
        return delegator;
    }

    private class RelationDefinition {
        private final String relatedEntityName;
        private final String fieldName;
        private final String relatedFieldName;

        private RelationDefinition(String relatedEntityName, String fieldName, String relatedFieldName) {
            this.relatedEntityName = relatedEntityName;
            this.fieldName = fieldName;
            this.relatedFieldName = relatedFieldName;
        }
    }

    static class RelatedKey {
        private final GenericValue gv;
        private final String relationName;

        private RelatedKey(GenericValue gv, String relationName) {
            this.gv = gv;
            this.relationName = relationName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelatedKey that = (RelatedKey)o;
            if (this.gv != null ? !this.gv.equals((Object)that.gv) : that.gv != null) {
                return false;
            }
            return !(this.relationName != null ? !this.relationName.equals(that.relationName) : that.relationName != null);
        }

        public int hashCode() {
            int result = this.gv != null ? this.gv.hashCode() : 0;
            result = 31 * result + (this.relationName != null ? this.relationName.hashCode() : 0);
            return result;
        }
    }
}

