/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class MockHttpSession
implements HttpSession {
    private final Map<String, Object> backingMap;
    private final long creationTime;

    public MockHttpSession() {
        this.backingMap = new HashMap<String, Object>();
        this.creationTime = System.currentTimeMillis();
    }

    public MockHttpSession(Map<String, Object> backingMap) {
        this.backingMap = backingMap;
        this.creationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return "session1234";
    }

    public long getLastAccessedTime() {
        return System.currentTimeMillis();
    }

    public ServletContext getServletContext() {
        return null;
    }

    public void setMaxInactiveInterval(int i) {
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String s) {
        return this.backingMap.get(s);
    }

    public Object getValue(String s) {
        return this.backingMap.get(s);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.backingMap.keySet());
    }

    public String[] getValueNames() {
        Set<String> strings = this.backingMap.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public void setAttribute(String s, Object o) {
        this.backingMap.put(s, o);
    }

    public void putValue(String s, Object o) {
        this.backingMap.put(s, o);
    }

    public void removeAttribute(String s) {
        this.backingMap.remove(s);
    }

    public void removeValue(String s) {
        this.backingMap.remove(s);
    }

    public void invalidate() {
        this.backingMap.clear();
    }

    public boolean isNew() {
        return false;
    }
}

