/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.mocks;

import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.google.common.base.Supplier;
import java.util.Map;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class VelocityTemplatingEngineMocks {
    public static Supplier<VelocityTemplatingEngine> alwaysOutput(String output) {
        return new ConstantOutputBuilder(output);
    }

    public static Supplier<VelocityTemplatingEngine> alwaysThrow(Exception expectedException) {
        return new AlwaysThrowOnRenderBuilder(expectedException);
    }

    private static class AlwaysThrowOnRenderBuilder
    implements Supplier<VelocityTemplatingEngine> {
        private final Exception expectedException;

        private AlwaysThrowOnRenderBuilder(Exception expectedException) {
            this.expectedException = expectedException;
        }

        public VelocityTemplatingEngine get() {
            return new VelocityTemplatingEngine(){

                public VelocityTemplatingEngine.RenderRequest render(TemplateSource source) {
                    VelocityTemplatingEngine.RenderRequest mockRequest = (VelocityTemplatingEngine.RenderRequest)Mockito.mock(VelocityTemplatingEngine.RenderRequest.class);
                    Mockito.when((Object)mockRequest.applying((Map)Matchers.any())).thenReturn((Object)mockRequest);
                    Mockito.when((Object)mockRequest.asHtml()).thenThrow(new Throwable[]{expectedException});
                    return mockRequest;
                }
            };
        }
    }

    private static class ConstantOutputBuilder
    implements Supplier<VelocityTemplatingEngine> {
        private final String output;

        private ConstantOutputBuilder(String output) {
            this.output = output;
        }

        public VelocityTemplatingEngine get() {
            return new VelocityTemplatingEngine(){

                public VelocityTemplatingEngine.RenderRequest render(TemplateSource source) {
                    VelocityTemplatingEngine.RenderRequest mockRequest = (VelocityTemplatingEngine.RenderRequest)Mockito.mock(VelocityTemplatingEngine.RenderRequest.class);
                    Mockito.when((Object)mockRequest.applying((Map)Matchers.any())).thenReturn((Object)mockRequest);
                    Mockito.when((Object)mockRequest.asHtml()).thenReturn((Object)output);
                    return mockRequest;
                }
            };
        }
    }
}

