/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DuckTypeProxyFactory {
    public static <T> T newStrictProxyInstance(Class<T> proxyInterface, Object delegate) {
        return DuckTypeProxyFactory.newProxyInstance(proxyInterface, delegate, true);
    }

    public static <T> T newLooseProxyInstance(Class<T> proxyInterface, Object delegate) {
        return DuckTypeProxyFactory.newProxyInstance(proxyInterface, delegate, false);
    }

    private static <T> T newProxyInstance(Class<T> proxyInterface, Object delegate, boolean strict) {
        return (T)Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new DelegatingInvocationHandler(delegate, strict));
    }

    private static final class DelegatingInvocationHandler
    implements InvocationHandler {
        private final Object delegate;
        private final boolean strict;
        private final Map<MethodSignature, Method> methods = new HashMap<MethodSignature, Method>();

        public DelegatingInvocationHandler(Object delegate, boolean strict) {
            this.delegate = delegate;
            this.strict = strict;
            for (Method method : delegate.getClass().getMethods()) {
                MethodSignature methodSignature = new MethodSignature(method);
                this.methods.put(methodSignature, method);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method delegateMethod = this.methods.get(new MethodSignature(method));
            if (delegateMethod == null) {
                if (this.strict) {
                    throw new UnsupportedOperationException("The delegate '" + this.delegate.getClass().getSimpleName() + "' does not implement method " + method);
                }
                return null;
            }
            try {
                return delegateMethod.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Unable to access " + this.delegate.getClass().getName() + " method " + delegateMethod, ex);
            }
        }

        private static final class MethodSignature {
            private final String name;
            private final Class<?>[] paramTypes;

            public MethodSignature(Method method) {
                this.name = method.getName();
                this.paramTypes = method.getParameterTypes();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MethodSignature that = (MethodSignature)o;
                if (!this.name.equals(that.name)) {
                    return false;
                }
                return Arrays.equals(this.paramTypes, that.paramTypes);
            }

            public int hashCode() {
                return this.name.hashCode();
            }
        }
    }
}

