/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.velocity;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.SimpleVelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class MockVelocityRequestContextFactory
implements VelocityRequestContextFactory {
    private final String staticBaseUrl;
    private final String canonicalBaseUrl;
    private String currentUrl;

    public MockVelocityRequestContextFactory(String baseUrl) {
        this(baseUrl, null);
    }

    public MockVelocityRequestContextFactory(String baseUrl, String staticBaseUrl) {
        this.currentUrl = baseUrl;
        this.canonicalBaseUrl = baseUrl;
        this.staticBaseUrl = staticBaseUrl;
    }

    public MockVelocityRequestContextFactory(String baseUrl, String canonicalBaseUrl, String staticBaseUrl) {
        this.currentUrl = baseUrl;
        this.canonicalBaseUrl = canonicalBaseUrl;
        this.staticBaseUrl = staticBaseUrl;
    }

    public VelocityRequestContext getJiraVelocityRequestContext() {
        return new SimpleVelocityRequestContext(this.currentUrl, this.canonicalBaseUrl, null, null);
    }

    public Map<String, Object> getDefaultVelocityParams(Map<String, Object> startingParams, JiraAuthenticationContext authenticationContext) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void cacheVelocityRequestContext(VelocityRequestContext velocityRequestContext) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void clearVelocityRequestContext() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setVelocityRequestContext(HttpServletRequest request) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setVelocityRequestContext(String baseUrl, HttpServletRequest request) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setVelocityRequestContext(VelocityRequestContext velocityRequestContext) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <I, O> O runWithStaticBaseUrl(@Nullable I input, @Nonnull Function<I, O> runnable) {
        String lastUrl = this.currentUrl;
        this.currentUrl = this.staticBaseUrl;
        try {
            Object object = runnable.apply(input);
            return (O)object;
        }
        finally {
            this.currentUrl = lastUrl;
        }
    }
}

