/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleAdminService;
import com.atlassian.jira.application.MockApplicationRole;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MockApplicationRoleAdminService
implements ApplicationRoleAdminService {
    public static final String NOT_FOUND = "Not Found";
    private Map<ApplicationKey, MockApplicationRole> roles = Maps.newHashMap();

    @Nonnull
    public ServiceOutcome<Set<ApplicationRole>> getRoles() {
        return ServiceOutcomeImpl.ok((Object)Sets.newHashSet(this.roles.values()));
    }

    @Nonnull
    public ServiceOutcome<ApplicationRole> getRole(@Nonnull ApplicationKey key) {
        MockApplicationRole role = this.roles.get(key);
        if (role == null) {
            return this.notFound();
        }
        return ServiceOutcomeImpl.ok((Object)role);
    }

    @Nonnull
    public ServiceOutcome<ApplicationRole> setRole(@Nonnull ApplicationRole role) {
        MockApplicationRole oldRole = this.roles.get(role.getKey());
        if (oldRole == null) {
            return this.notFound();
        }
        MockApplicationRole newRole = new MockApplicationRole(role);
        this.roles.put(role.getKey(), newRole);
        return ServiceOutcomeImpl.ok((Object)newRole);
    }

    @Nonnull
    public ServiceOutcome<Set<ApplicationRole>> setRoles(@Nonnull Collection<ApplicationRole> rolesList) {
        for (ApplicationRole role : rolesList) {
            MockApplicationRole oldRole = this.roles.get(role.getKey());
            if (oldRole != null) continue;
            return this.notFoundSet();
        }
        for (ApplicationRole role : rolesList) {
            this.roles.put(role.getKey(), new MockApplicationRole(role));
        }
        return ServiceOutcomeImpl.ok(new HashSet<ApplicationRole>(rolesList));
    }

    private ServiceOutcomeImpl<ApplicationRole> notFound() {
        return ServiceOutcomeImpl.error((String)NOT_FOUND, (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND);
    }

    private ServiceOutcomeImpl<Set<ApplicationRole>> notFoundSet() {
        return ServiceOutcomeImpl.error((String)NOT_FOUND, (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND);
    }

    public MockApplicationRole addApplicationRole(String id) {
        MockApplicationRole role = new MockApplicationRole().key(id);
        this.roles.put(role.getKey(), role);
        return role;
    }
}

