/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MockApplicationRoleStore
implements ApplicationRoleStore {
    private final Map<ApplicationKey, ApplicationRoleStore.ApplicationRoleData> data = Maps.newHashMap();

    @Nonnull
    public ApplicationRoleStore.ApplicationRoleData get(@Nonnull ApplicationKey key) {
        ApplicationRoleStore.ApplicationRoleData applicationRoleData = this.data.get(key);
        if (applicationRoleData == null) {
            return new ApplicationRoleStore.ApplicationRoleData(key, Collections.emptyList(), (Iterable)Option.none(), false);
        }
        return applicationRoleData;
    }

    @Nonnull
    public ApplicationRoleStore.ApplicationRoleData save(@Nonnull ApplicationRoleStore.ApplicationRoleData data) {
        this.data.put(data.getKey(), data);
        return data;
    }

    public void removeGroup(@Nonnull String groupName) {
        for (Map.Entry<ApplicationKey, ApplicationRoleStore.ApplicationRoleData> e : this.data.entrySet()) {
            ApplicationRoleStore.ApplicationRoleData value = e.getValue();
            Set eGroups = value.getGroups();
            if (!value.getGroups().contains(groupName)) continue;
            HashSet newGroup = new HashSet(eGroups);
            newGroup.remove(groupName);
            this.data.put(value.getKey(), new ApplicationRoleStore.ApplicationRoleData(value.getKey(), newGroup, (Iterable)value.getDefaultGroups(), value.isSelectedByDefault()));
        }
    }

    public void removeByKey(@Nonnull ApplicationKey key) {
        this.data.remove(key);
    }

    public MockApplicationRoleStore save(ApplicationKey key, String ... groups) {
        this.save(new ApplicationRoleStore.ApplicationRoleData(key, Arrays.asList(groups), (Iterable)Option.none(String.class), false));
        return this;
    }

    public MockApplicationRoleStore save(ApplicationKey key, Group ... groups) {
        this.save(new ApplicationRoleStore.ApplicationRoleData(key, MockApplicationRoleStore.toNames(Arrays.asList(groups)), (Iterable)Option.none(String.class), false));
        return this;
    }

    public MockApplicationRoleStore save(ApplicationRole role) {
        this.save(new ApplicationRoleStore.ApplicationRoleData(role.getKey(), MockApplicationRoleStore.toNames(role.getGroups()), MockApplicationRoleStore.toNames(role.getDefaultGroups()), role.isSelectedByDefault()));
        return this;
    }

    private static Iterable<String> toNames(Collection<Group> groups) {
        return (Iterable)groups.stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
    }
}

