/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import java.util.Collection;
import org.junit.Assert;

public class ProjectComponentStoreTester {
    private final ProjectComponentStore store;
    public static final String NO_SUCH_NAME = "Rwaya";
    public static final Long PROJECT_ID_1 = new Long(1L);
    public static final Long PROJECT_ID_2 = new Long(2L);
    public static final Long COMPONENT_ID_NOT_STORED = new Long(123L);

    public ProjectComponentStoreTester(ProjectComponentStore store) {
        this.store = store;
    }

    public void testFind() {
        this.verifyFindWithInvalidIds();
        this.verifyFindWithValidId();
        this.verifyFindWithInvalidIds();
    }

    private void verifyFindWithValidId() {
        try {
            MutableProjectComponent component = new MutableProjectComponent(null, "name", "desc", null, 0L, PROJECT_ID_1);
            component = this.store.store(component);
            MutableProjectComponent pc = this.store.find(component.getId());
            Assert.assertNotNull((Object)pc);
            Assert.assertEquals((Object)component.getId(), (Object)pc.getId());
        }
        catch (EntityNotFoundException e) {
            Assert.fail();
        }
    }

    private void verifyFindWithInvalidIds() {
        try {
            this.store.find(null);
            Assert.fail();
        }
        catch (EntityNotFoundException e) {
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.store.find(COMPONENT_ID_NOT_STORED);
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    public void testFindAllForProject() {
        this.verifyFindAllWithInvalidProjectId();
        try {
            MutableProjectComponent component1 = new MutableProjectComponent(null, "name1", "desc", null, 0L, PROJECT_ID_2);
            MutableProjectComponent component2 = new MutableProjectComponent(null, "name2", "desc", null, 0L, PROJECT_ID_2);
            component1 = this.store.store(component1);
            component2 = this.store.store(component2);
            Collection components = this.store.findAllForProject(PROJECT_ID_2);
            Assert.assertNotNull((Object)components);
            Assert.assertEquals((long)2L, (long)components.size());
            Assert.assertTrue((boolean)components.contains(component1));
            Assert.assertTrue((boolean)components.contains(component2));
        }
        catch (EntityNotFoundException e) {
            Assert.fail();
        }
        this.verifyFindAllWithInvalidProjectId();
    }

    public void testFindByComponentName() {
        this.verifyFindAllWithInvalidProjectId();
        try {
            MutableProjectComponent component1 = new MutableProjectComponent(null, "name1", "desc", null, 0L, PROJECT_ID_2);
            MutableProjectComponent component2 = new MutableProjectComponent(null, "name", "desc", null, 0L, PROJECT_ID_2);
            MutableProjectComponent component3 = new MutableProjectComponent(null, "Name", "desc", null, 0L, PROJECT_ID_1);
            component1 = this.store.store(component1);
            component2 = this.store.store(component2);
            component3 = this.store.store(component3);
            Collection components = this.store.findByComponentNameCaseInSensitive("name");
            Assert.assertNotNull((Object)components);
            Assert.assertEquals((long)2L, (long)components.size());
            Assert.assertTrue((boolean)components.contains(component2));
            Assert.assertTrue((boolean)components.contains(component3));
        }
        catch (EntityNotFoundException e) {
            Assert.fail();
        }
    }

    private void verifyFindAllWithInvalidProjectId() {
        Collection components = this.store.findAllForProject(PROJECT_ID_1);
        Assert.assertNotNull((Object)components);
        Assert.assertTrue((boolean)components.isEmpty());
    }

    public void testFindProjectIdForComponent() {
        try {
            MutableProjectComponent component = new MutableProjectComponent(null, "name", "desc", null, 0L, PROJECT_ID_1);
            component = this.store.store(component);
            Assert.assertEquals((Object)PROJECT_ID_1, (Object)this.store.findProjectIdForComponent(component.getId()));
        }
        catch (EntityNotFoundException e) {
            Assert.fail();
        }
        try {
            this.store.findProjectIdForComponent(COMPONENT_ID_NOT_STORED);
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    public void testDelete() {
        try {
            MutableProjectComponent component1 = new MutableProjectComponent(null, "name1", "desc", null, 0L, PROJECT_ID_1);
            MutableProjectComponent component2 = new MutableProjectComponent(null, "name2", "desc", null, 0L, PROJECT_ID_1);
            component1 = this.store.store(component1);
            component2 = this.store.store(component2);
            Assert.assertNotNull((Object)this.store.find(component1.getId()));
            Assert.assertNotNull((Object)this.store.find(component2.getId()));
            Assert.assertTrue((boolean)this.store.containsName(component1.getName(), PROJECT_ID_1));
            Assert.assertTrue((boolean)this.store.containsName(component2.getName(), PROJECT_ID_1));
            Assert.assertEquals((long)2L, (long)this.store.findAllForProject(PROJECT_ID_1).size());
            this.store.delete(component1.getId());
            try {
                this.store.find(component1.getId());
                Assert.fail();
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            Assert.assertNotNull((Object)this.store.find(component2.getId()));
            Assert.assertFalse((boolean)this.store.containsName(component1.getName(), PROJECT_ID_1));
            Assert.assertTrue((boolean)this.store.containsName(component2.getName(), PROJECT_ID_1));
            Assert.assertEquals((long)1L, (long)this.store.findAllForProject(PROJECT_ID_1).size());
            this.store.delete(component2.getId());
            try {
                this.store.find(component1.getId());
                Assert.fail();
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            try {
                this.store.find(component2.getId());
                Assert.fail();
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)this.store.containsName(component1.getName(), PROJECT_ID_1));
            Assert.assertFalse((boolean)this.store.containsName(component2.getName(), PROJECT_ID_1));
            Assert.assertEquals((long)0L, (long)this.store.findAllForProject(PROJECT_ID_1).size());
        }
        catch (EntityNotFoundException e) {
            Assert.fail();
        }
    }

    public void testDeleteAll() {
        try {
            MutableProjectComponent component1 = new MutableProjectComponent(null, "name1", "desc", null, 0L, PROJECT_ID_1);
            MutableProjectComponent component2 = new MutableProjectComponent(null, "name2", "desc", null, 0L, PROJECT_ID_1);
            component1 = this.store.store(component1);
            component2 = this.store.store(component2);
            Assert.assertNotNull((Object)this.store.find(component1.getId()));
            Assert.assertNotNull((Object)this.store.find(component2.getId()));
            Assert.assertTrue((boolean)this.store.containsName(component1.getName(), PROJECT_ID_1));
            Assert.assertTrue((boolean)this.store.containsName(component2.getName(), PROJECT_ID_1));
            Assert.assertEquals((long)2L, (long)this.store.findAllForProject(PROJECT_ID_1).size());
            this.store.deleteAllComponents(PROJECT_ID_1);
            try {
                this.store.find(component1.getId());
                Assert.fail();
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            try {
                this.store.find(component2.getId());
                Assert.fail();
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)this.store.containsName(component1.getName(), PROJECT_ID_1));
            Assert.assertFalse((boolean)this.store.containsName(component2.getName(), PROJECT_ID_1));
            Assert.assertEquals((long)0L, (long)this.store.findAllForProject(PROJECT_ID_1).size());
        }
        catch (EntityNotFoundException e) {
            Assert.fail();
        }
    }

    public void testUpdate() {
        MutableProjectComponent component1 = new MutableProjectComponent(new Long(1L), "name1", "desc", null, 0L, PROJECT_ID_1);
        try {
            this.store.store(component1);
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        MutableProjectComponent component2 = new MutableProjectComponent(new Long(2L), "name1", "desc", null, 0L, PROJECT_ID_1);
        try {
            this.store.store(component2);
            Assert.fail();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    public void testContainsName() {
        try {
            this.store.containsName(null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.store.containsName("name", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.store.containsName(null, new Long(1L));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

