/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.config.properties.PropertiesAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

public class MockPropertiesAccessor
implements PropertiesAccessor {
    private final Map<String, String> propertyOverrides = new HashMap<String, String>();

    public String getProperty(@Nonnull String key) {
        if (this.propertyOverrides.containsKey(key)) {
            return this.propertyOverrides.get(key);
        }
        return System.getProperty(key);
    }

    public void setProperty(@Nonnull String key, @Nonnull String value) {
        this.propertyOverrides.put(key, value);
    }

    public void unsetProperty(@Nonnull String key) {
        this.propertyOverrides.put(key, null);
    }

    public Properties getProperties() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setProperties(@Nonnull Properties props) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Boolean getBoolean(@Nonnull String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public Integer getInteger(@Nonnull String key) {
        String val = this.getProperty(key);
        return val == null ? null : Integer.valueOf(Integer.parseInt(val));
    }

    public Long getLong(@Nonnull String key) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void refresh() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void refresh(@Nonnull String key) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

