/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.util.IndexPathManager;

public class MockIndexPathManager
implements IndexPathManager {
    private String path;
    private boolean jiraHome = false;
    public static final String DEFAULT_PATH = "/a/b/index/path";

    public MockIndexPathManager() {
        this.path = DEFAULT_PATH;
    }

    public MockIndexPathManager(String path) {
        this.path = path;
    }

    public String getIndexRootPath() {
        return this.path;
    }

    public String getDefaultIndexRootPath() {
        return "/jira_home/caches/indexes/";
    }

    public String getIssueIndexPath() {
        return this.getIndexRootPath() + "issues";
    }

    public String getCommentIndexPath() {
        return this.getIndexRootPath() + "comments";
    }

    public String getChangeHistoryIndexPath() {
        return this.getIndexRootPath() + "changes";
    }

    public String getWorklogIndexPath() {
        return this.getIndexRootPath() + "worklogs";
    }

    public String getPluginIndexRootPath() {
        return this.getIndexRootPath() + "plugins";
    }

    public String getSharedEntityIndexPath() {
        return this.getIndexRootPath() + "entities";
    }

    public void setIndexRootPath(String indexPath) {
        this.path = indexPath;
        this.jiraHome = false;
    }

    public void setUseDefaultDirectory() {
        this.jiraHome = false;
    }

    public boolean getUseDefaultDirectory() {
        return this.jiraHome;
    }

    public IndexPathManager.Mode getMode() {
        if (this.jiraHome) {
            return IndexPathManager.Mode.DEFAULT;
        }
        return IndexPathManager.Mode.CUSTOM;
    }
}

