/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.ConnectionProvider;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.DbConnectionImpl;
import com.atlassian.jira.database.DuckTypeConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.ResultRow;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.util.DuckTypeProxyFactory;
import com.google.common.base.Preconditions;
import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.SQLTemplates;
import java.sql.Connection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.mockito.Mockito;
import org.ofbiz.core.entity.DelegatorInterface;

public class MockQueryDslAccessor
implements QueryDslAccessor {
    private static final SQLTemplates DIALECT = SQLTemplates.DEFAULT;
    private final DuckTypeConnection duckTypeConnection = new DuckTypeConnection();
    private final Connection proxyConnection = DuckTypeProxyFactory.newStrictProxyInstance(Connection.class, this.duckTypeConnection);
    private final DelegatorInterface mockDelegatorInterface = (DelegatorInterface)Mockito.mock(DelegatorInterface.class);

    public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
        return (T)MockQueryDslAccessor.assertFinished(callback.runQuery((DbConnection)new DbConnectionImpl(this.proxyConnection, DIALECT, this.mockDelegatorInterface)));
    }

    public void execute(@Nonnull SqlCallback callback) {
        callback.run((DbConnection)new DbConnectionImpl(this.proxyConnection, DIALECT, this.mockDelegatorInterface));
    }

    public ConnectionProvider withNewConnection() {
        return new ConnectionProvider(){

            public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
                return (T)MockQueryDslAccessor.assertFinished(callback.runQuery((DbConnection)new DbConnectionImpl(MockQueryDslAccessor.this.proxyConnection, DIALECT, MockQueryDslAccessor.this.mockDelegatorInterface)));
            }

            public void execute(@Nonnull SqlCallback callback) {
                callback.run((DbConnection)new DbConnectionImpl(MockQueryDslAccessor.this.proxyConnection, DIALECT, MockQueryDslAccessor.this.mockDelegatorInterface));
            }
        };
    }

    public ConnectionProvider withLegacyOfBizTransaction() {
        return new ConnectionProvider(){

            public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
                return (T)MockQueryDslAccessor.assertFinished(callback.runQuery((DbConnection)new DbConnectionImpl(MockQueryDslAccessor.this.proxyConnection, DIALECT, MockQueryDslAccessor.this.mockDelegatorInterface)));
            }

            public void execute(@Nonnull SqlCallback callback) {
                callback.run((DbConnection)new DbConnectionImpl(MockQueryDslAccessor.this.proxyConnection, DIALECT, MockQueryDslAccessor.this.mockDelegatorInterface));
            }
        };
    }

    public DbConnection withDbConnection(Connection connection) {
        return new DbConnectionImpl(connection, DIALECT, this.mockDelegatorInterface);
    }

    @Nonnull
    public DuckTypeConnection getConnection() {
        return this.duckTypeConnection;
    }

    public void setQueryResults(String sql, Iterable<ResultRow> expectedResults) {
        this.duckTypeConnection.setQueryResults(sql, expectedResults);
    }

    public void setQueryResults(String sql, ResultRow expectedResult) {
        this.setQueryResults(sql, Collections.singletonList(expectedResult));
    }

    public void setUpdateResults(String sql, Supplier<RuntimeException> exFactory) {
        this.duckTypeConnection.setUpdateResults(sql, exFactory);
    }

    public void reset() {
        this.duckTypeConnection.reset();
    }

    public void onSqlListener(String sql, Runnable action) {
        this.duckTypeConnection.onSqlListener(sql, action);
    }

    public void setQueryEphemeralResults(String sql, Iterable<ResultRow> firstResults, Iterable<ResultRow> laterResults) {
        this.duckTypeConnection.setQueryResults(sql, firstResults);
        this.duckTypeConnection.onSqlListener(sql, () -> this.duckTypeConnection.setQueryResults(sql, laterResults));
    }

    public void setUpdateResults(String sql, int rowCount) {
        this.duckTypeConnection.setUpdateResults(sql, rowCount);
    }

    public void assertAllExpectedStatementsWereRun() {
        this.duckTypeConnection.assertAllExpectedStatementsWereRun();
    }

    public DelegatorInterface getMockDelegatorInterface() {
        return this.mockDelegatorInterface;
    }

    public void setDefaultQueryResult(@Nonnull Iterable<ResultRow> defaultQueryResult) {
        Preconditions.checkNotNull(defaultQueryResult);
        this.duckTypeConnection.setDefaultQueryResult(defaultQueryResult);
    }

    public void setDefaultUpdateResult(int defaultUpdateResult) {
        this.duckTypeConnection.setDefaultUpdateResult(defaultUpdateResult);
    }

    private static <T> T assertFinished(T result) {
        if (result instanceof AbstractSQLQuery) {
            Assert.fail((String)("Query completed with type '" + result.getClass().getName() + "'.  You probably closed the executeQuery callback prematurely.\n" + result));
        }
        return result;
    }

    public String toString() {
        return "MockQueryDslAccessor[duckTypeConnection=" + this.duckTypeConnection + ']';
    }
}

