/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.HelpUrl;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MockHelpUrl
implements HelpUrl {
    private String url;
    private String alt;
    private String description;
    private String title;
    private String key;
    private boolean local;

    public MockHelpUrl() {
    }

    public MockHelpUrl(HelpUrl url) {
        this.url = url.getUrl();
        this.title = url.getTitle();
        this.alt = url.getAlt();
        this.description = url.getDescription();
        this.key = url.getKey();
        this.local = url.isLocal();
    }

    public static MockHelpUrl simpleUrl(String key) {
        return new MockHelpUrl().setUrl(String.format("url.%s", key)).setAlt(String.format("alt.%s", key)).setDescription(String.format("description.%s", key)).setTitle(String.format("title.%s", key)).setKey(String.format("key.%s", key));
    }

    public MockHelpUrl setUrl(String url) {
        this.url = url;
        return this;
    }

    public MockHelpUrl setAlt(String alt) {
        this.alt = alt;
        return this;
    }

    public MockHelpUrl setDescription(String description) {
        this.description = description;
        return this;
    }

    public MockHelpUrl setTitle(String title) {
        this.title = title;
        return this;
    }

    public MockHelpUrl setKey(String key) {
        this.key = key;
        return this;
    }

    public MockHelpUrl setLocal(boolean local) {
        this.local = local;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLocal() {
        return this.local;
    }

    public MockHelpUrl copy() {
        return new MockHelpUrl(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockHelpUrl that = (MockHelpUrl)o;
        if (this.local != that.local) {
            return false;
        }
        if (this.alt != null ? !this.alt.equals(that.alt) : that.alt != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.alt != null ? this.alt.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.local ? 1 : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

