/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringEscapeUtils;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Locale;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ofbiz.core.entity.GenericValue;

public class MockIssueConstant
implements IssueConstant {
    private final String id;
    private String name;
    private String translatedName;
    private long sequence = 0L;
    private String iconUrl = null;
    private String description;
    private GenericValue genericValue;

    public MockIssueConstant(GenericValue genericValue) {
        this.id = genericValue.getString("id");
        this.name = genericValue.getString("name");
        this.genericValue = genericValue;
    }

    public MockIssueConstant(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public String getCompleteIconUrl() {
        return this.getIconUrl();
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getIconUrlHtml() {
        return StringEscapeUtils.escapeHtml((String)this.getIconUrl());
    }

    public void setIconUrl(String iconURL) {
        this.iconUrl = iconURL;
    }

    public MockIssueConstant url(String url) {
        this.iconUrl = url;
        return this;
    }

    public String getNameTranslation() {
        return this.translatedName == null ? this.name : this.translatedName;
    }

    public MockIssueConstant setTranslatedName(String translatedName) {
        this.translatedName = translatedName;
        return this;
    }

    public String getDescTranslation() {
        return this.description;
    }

    public String getNameTranslation(String locale) {
        return this.getNameTranslation();
    }

    public String getDescTranslation(String locale) {
        return this.getDescTranslation();
    }

    public String getNameTranslation(I18nHelper i18n) {
        return this.getNameTranslation();
    }

    public String getDescTranslation(I18nHelper i18n) {
        return this.getDescription();
    }

    public void setTranslation(String translatedName, String translatedDesc, String issueConstantPrefix, Locale locale) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void deleteTranslation(String issueConstantPrefix, Locale locale) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public PropertySet getPropertySet() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public int compareTo(Object o) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockIssueConstant that = (MockIssueConstant)o;
        if (this.sequence != that.sequence) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(that.iconUrl) : that.iconUrl != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

