/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.MockApplicationUser;
import com.atlassian.jira.util.JiraDateUtils;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MockComment
implements MutableComment {
    private final Long id;
    private ApplicationUser author;
    private ApplicationUser updateAuthor;
    private String body;
    private String groupLevel;
    private Long roleLevelId;
    private Date created;
    private Date updated;
    private final Issue issue;
    public static final String COMMENT_ROLE_NAME = "My Role";
    public static final String COMMENT_ROLE_DESCRIPTION = "My Test Role";

    public MockComment(String author, String body) {
        this(author, body, null, null, null);
    }

    public MockComment(String author, String body, String groupLevel, Long roleLevelId) {
        this(author, body, groupLevel, roleLevelId, null);
    }

    public MockComment(String author, String body, String groupLevel, Long roleLevelId, Date created) {
        this(null, author, body, groupLevel, roleLevelId, created, null);
    }

    public MockComment(Long id, String author, String body, String groupLevel, Long roleLevelId, Date created, Issue issue) {
        this(id, author, null, body, groupLevel, roleLevelId, created, null, issue);
    }

    public MockComment(Long id, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, Issue issue) {
        Date createdDate;
        this.id = id;
        this.author = author == null ? null : new MockApplicationUser(author);
        this.updateAuthor = updateAuthor == null ? null : new MockApplicationUser(updateAuthor);
        this.body = body == null ? "" : body;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.created = createdDate = JiraDateUtils.copyOrCreateDateNullsafe((Date)created);
        this.updated = updated == null ? createdDate : updated;
        this.issue = issue;
    }

    public String getUpdateAuthor() {
        return this.updateAuthor.getKey();
    }

    public ApplicationUser getUpdateAuthorUser() {
        return null;
    }

    public ApplicationUser getUpdateAuthorApplicationUser() {
        return this.updateAuthor;
    }

    public String getUpdateAuthorFullName() {
        return null;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockComment comment = (MockComment)o;
        if (this.author != null ? !this.author.equals((Object)comment.author) : comment.author != null) {
            return false;
        }
        if (!this.body.equals(comment.body)) {
            return false;
        }
        if (this.created != null ? !this.created.equals(comment.created) : comment.created != null) {
            return false;
        }
        if (this.groupLevel != null ? !this.groupLevel.equals(comment.groupLevel) : comment.groupLevel != null) {
            return false;
        }
        if (!this.id.equals(comment.id)) {
            return false;
        }
        if (!this.issue.equals((Object)comment.issue)) {
            return false;
        }
        return !(this.roleLevelId != null ? !this.roleLevelId.equals(comment.roleLevelId) : comment.roleLevelId != null);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("author", (Object)this.author).append("updateAuthor", (Object)this.updateAuthor).append("body", (Object)this.body).append("groupLevel", (Object)this.groupLevel).append("roleLevelId", (Object)this.roleLevelId).append("created", (Object)this.created).append("updated", (Object)this.updated).append("issue", (Object)this.issue).toString();
    }

    public String getAuthor() {
        return this.author.getKey();
    }

    public String getAuthorKey() {
        return this.author.getKey();
    }

    public ApplicationUser getAuthorUser() {
        return this.author;
    }

    public ApplicationUser getAuthorApplicationUser() {
        return this.author;
    }

    public String getAuthorFullName() {
        return this.author.getDisplayName();
    }

    public String getBody() {
        return this.body;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getGroupLevel() {
        return this.groupLevel;
    }

    public Long getId() {
        return this.id;
    }

    public Long getRoleLevelId() {
        return this.roleLevelId;
    }

    public ProjectRole getRoleLevel() {
        return this.roleLevelId == null ? null : new ProjectRoleImpl(this.roleLevelId, COMMENT_ROLE_NAME, COMMENT_ROLE_DESCRIPTION);
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void setAuthor(ApplicationUser author) {
        this.author = author;
    }

    public void setAuthor(String author) {
        this.author = new MockApplicationUser(author);
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setGroupLevel(String groupLevel) {
        this.groupLevel = groupLevel;
    }

    public void setRoleLevelId(Long roleLevelId) {
        this.roleLevelId = roleLevelId;
    }

    public void setUpdateAuthor(ApplicationUser updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public void setUpdateAuthor(String updateAuthor) {
        this.updateAuthor = new MockApplicationUser(updateAuthor);
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }
}

