/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.MockFieldScreenTab;
import com.atlassian.jira.util.CollectionReorderer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ofbiz.core.entity.GenericValue;

public class MockFieldScreen
implements FieldScreen {
    private List<FieldScreenTab> tabs = new ArrayList<FieldScreenTab>();
    private Long id;
    private String name;
    private String description;
    private boolean stored = false;

    public MockFieldScreen() {
    }

    public MockFieldScreen(long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public MockFieldScreen name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<FieldScreenTab> getTabs() {
        return this.tabs;
    }

    public FieldScreenTab getTab(int tabPosition) {
        return this.tabs.get(tabPosition);
    }

    public MockFieldScreen addTab(FieldScreenTab tab) {
        tab.setPosition(this.tabs.size());
        this.tabs.add(tab);
        tab.setFieldScreen((FieldScreen)this);
        return this;
    }

    public MockFieldScreenTab addMockTab() {
        MockFieldScreenTab tab = new MockFieldScreenTab();
        this.addTab(tab);
        return tab;
    }

    public FieldScreenTab addTab(String tabName) {
        MockFieldScreenTab tab = this.addMockTab();
        tab.setName(tabName);
        return tab;
    }

    public void removeTab(int tabPosition) {
        this.tabs.remove(tabPosition);
        for (int i = tabPosition; i < this.tabs.size(); ++i) {
            this.tabs.get(i).setPosition(i);
        }
    }

    public void moveFieldScreenTabToPosition(int tabPosition, int newPosition) {
        CollectionReorderer.moveToPosition(this.tabs, (int)tabPosition, (int)newPosition);
        this.resequence();
    }

    public void moveFieldScreenTabLeft(int tabPosition) {
        throw new UnsupportedOperationException();
    }

    public void moveFieldScreenTabRight(int tabPosition) {
        throw new UnsupportedOperationException();
    }

    public void resequence() {
        int count = 0;
        for (FieldScreenTab fieldScreenTab : this.getTabs()) {
            fieldScreenTab.setPosition(count++);
        }
    }

    public GenericValue getGenericValue() {
        throw new UnsupportedOperationException();
    }

    public void setGenericValue(GenericValue genericValue) {
        throw new UnsupportedOperationException();
    }

    public boolean isModified() {
        return false;
    }

    public void store() {
        this.stored = true;
    }

    public boolean resetStored() {
        boolean lastStored = this.stored;
        this.stored = false;
        return lastStored;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean containsField(String fieldId) {
        for (FieldScreenTab tab : this.getTabs()) {
            if (tab.getFieldScreenLayoutItem(fieldId) == null) continue;
            return true;
        }
        return false;
    }

    public void removeFieldScreenLayoutItem(String fieldId) {
        for (FieldScreenTab tab : this.getTabs()) {
            for (int i = 0; i < tab.getFieldScreenLayoutItems().size(); ++i) {
                FieldScreenLayoutItem item = tab.getFieldScreenLayoutItem(i);
                if (!fieldId.equals(item.getFieldId())) continue;
                tab.removeFieldScreenLayoutItem(i);
                return;
            }
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockFieldScreen that = (MockFieldScreen)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.tabs != null ? !this.tabs.equals(that.tabs) : that.tabs != null);
    }

    public int hashCode() {
        int result = this.tabs != null ? this.tabs.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

