/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.junit.rules;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class Log4jLogger
extends TestWatcher {
    private final String category;
    private WriterAppender writerAppender;
    private StringWriter writer;

    public Log4jLogger(String category) {
        this.category = category;
    }

    public Log4jLogger() {
        this("");
    }

    public Log4jLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    protected void starting(Description description) {
        this.writer = new StringWriter();
        this.writerAppender = new WriterAppender((Layout)new SimpleLayout(), (Writer)this.writer);
        Logger logger = this.getLogger();
        logger.setLevel(Level.ALL);
        logger.addAppender((Appender)this.writerAppender);
    }

    private Logger getLogger() {
        return StringUtils.isBlank((CharSequence)this.category) ? Logger.getRootLogger() : Logger.getLogger((String)this.category);
    }

    protected void finished(Description description) {
        Logger.getRootLogger().removeAppender((Appender)this.writerAppender);
    }

    public String getMessage() {
        return this.writer.toString();
    }

    public void reset() {
        this.writer = new StringWriter();
        this.writerAppender.setWriter((Writer)this.writer);
    }

    public void setLevel(Level level) {
        this.getLogger().setLevel(level);
    }
}

