/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.collectors.CollectorsUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class HasItemsInOrderMatcher<T>
extends TypeSafeDiagnosingMatcher<Iterable<T>> {
    private final Iterable<Matcher<T>> expectedElements;

    HasItemsInOrderMatcher(Iterable<Matcher<T>> expectedElements) {
        this.expectedElements = expectedElements;
    }

    protected boolean matchesSafely(Iterable<T> items, Description mismatchDescription) {
        boolean containsAll = true;
        Iterator<T> elementsLookup = items.iterator();
        for (Matcher<T> expectedElement : this.expectedElements) {
            boolean elementFound = false;
            while (elementsLookup.hasNext() && !elementFound) {
                elementFound = expectedElement.matches(elementsLookup.next());
            }
            if (elementFound) continue;
            mismatchDescription.appendText("expected element ").appendDescriptionOf(expectedElement).appendText(" did not match in ").appendValueList("[", ", ", "]", items);
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void describeTo(Description description) {
        description.appendText("looking for elements in order: ").appendList("[", ", ", "]", this.expectedElements);
    }

    public static <U> Matcher<Iterable<U>> hasMatchingItemsInOrder(Iterable<Matcher<U>> expected) {
        return new HasItemsInOrderMatcher(expected);
    }

    @SafeVarargs
    public static <U> Matcher<Iterable<U>> hasItemsInOrder(U ... expected) {
        Iterable itemz = (Iterable)Arrays.stream(expected).map(Matchers::equalTo).collect(CollectorsUtil.toImmutableListWithCapacity((int)expected.length));
        return HasItemsInOrderMatcher.hasMatchingItemsInOrder(itemz);
    }

    public static <U> Matcher<Iterable<U>> hasItemsInOrder(Iterable<U> expected) {
        Iterable itemz = (Iterable)StreamSupport.stream(expected.spliterator(), false).map(Matchers::equalTo).collect(CollectorsUtil.toImmutableList());
        return HasItemsInOrderMatcher.hasMatchingItemsInOrder(itemz);
    }
}

