/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.jira.config.properties.ApplicationProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MockApplicationProperties
implements ApplicationProperties {
    final Map<String, Object> properties;
    final Map<String, Object> defaultValues = new HashMap<String, Object>();
    private String encoding = "UTF-8";
    private Locale defaultLocale = Locale.getDefault();

    public MockApplicationProperties() {
        this.properties = new HashMap<String, Object>();
    }

    public MockApplicationProperties(Map<String, Object> initialProperties) {
        this.properties = initialProperties;
    }

    public String getText(String name) {
        return (String)this.properties.get(name);
    }

    public String getDefaultBackedText(String name) {
        return (String)this.properties.getOrDefault(name, this.defaultValues.get(name));
    }

    public void setText(String name, String value) {
        if (value == null) {
            if (StringUtils.isNotEmpty((String)this.getDefaultBackedString(name))) {
                this.properties.remove(name);
            }
        } else {
            this.properties.put(name, value);
        }
    }

    public String getString(String name) {
        return this.getText(name);
    }

    public Collection<String> getDefaultKeys() {
        return Collections.emptySet();
    }

    public String getDefaultBackedString(String name) {
        return (String)this.properties.getOrDefault(name, this.getDefaultString(name));
    }

    public String getDefaultString(String name) {
        return (String)this.defaultValues.get(name);
    }

    public void setString(String name, String value) {
        this.setText(name, value);
    }

    public void setDefaultString(String name, String value) {
        this.defaultValues.put(name, value);
    }

    public boolean getOption(String key) {
        Object obj = this.properties.get(key);
        if (obj instanceof String) {
            return "true".equalsIgnoreCase((String)obj);
        }
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public Collection<String> getKeys() {
        return this.properties.keySet();
    }

    public void setOption(String key, boolean value) {
        this.properties.put(key, value);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMailEncoding() {
        return "UTF-8";
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getContentType() {
        return null;
    }

    public void refresh() {
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public MockApplicationProperties setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
        return this;
    }

    public Collection<String> getStringsWithPrefix(String prefix) {
        return Collections.emptySet();
    }

    public Map<String, Object> asMap() {
        return this.properties;
    }
}

