/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class MockFeatureManager
implements FeatureManager {
    private DarkFeatures darkFeatures = new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    private final Set<String> enabledFeatures = new HashSet<String>();
    private final Set<FeatureFlag> registeredFeatureFlags = new HashSet<FeatureFlag>();
    private final Set<FeatureFlag> activatedFeatureFlags = new HashSet<FeatureFlag>();

    public boolean isEnabled(String featureKey) {
        return this.enabledFeatures.contains(featureKey) || this.darkFeatures.getAllEnabledFeatures().contains(featureKey);
    }

    public boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.featureKey());
    }

    public boolean isEnabled(FeatureFlag featureFlag) {
        if (this.isEnabled(featureFlag.enabledFeatureKey())) {
            return true;
        }
        return (featureFlag.isOnByDefault() || this.activatedFeatureFlags.contains(featureFlag)) && !this.isEnabled(featureFlag.disabledFeatureKey());
    }

    public Option<FeatureFlag> getFeatureFlag(String featureKey) {
        return Iterables.findFirst(this.registeredFeatureFlags, featureFlag -> StringUtils.equals((String)featureFlag.featureKey(), (String)featureKey));
    }

    public boolean isEnabled(CoreFeatures feature) {
        return this.isEnabled(feature.featureKey());
    }

    @Deprecated
    public void enable(CoreFeatures feature) {
        this.enableFeature(feature);
    }

    public MockFeatureManager enableFeature(CoreFeatures feature) {
        this.enabledFeatures.add(feature.featureKey());
        return this;
    }

    public MockFeatureManager disableFeature(CoreFeatures feature) {
        this.enabledFeatures.remove(feature.featureKey());
        return this;
    }

    @Deprecated
    public void enable(Feature feature) {
        this.enableFeature(feature);
    }

    public MockFeatureManager enableFeature(Feature feature) {
        this.enabledFeatures.add(feature.featureKey());
        return this;
    }

    @Deprecated
    public MockFeatureManager disable(Feature feature) {
        return this.disableFeature(feature);
    }

    public MockFeatureManager disableFeature(Feature feature) {
        this.enabledFeatures.remove(feature.featureKey());
        return this;
    }

    public MockFeatureManager enableFeature(FeatureFlag feature) {
        this.enabledFeatures.add(feature.enabledFeatureKey());
        this.enabledFeatures.remove(feature.disabledFeatureKey());
        return this;
    }

    public MockFeatureManager disableFeature(FeatureFlag feature) {
        this.enabledFeatures.add(feature.disabledFeatureKey());
        this.enabledFeatures.remove(feature.enabledFeatureKey());
        return this;
    }

    public MockFeatureManager resetFeature(FeatureFlag feature) {
        this.enabledFeatures.remove(feature.disabledFeatureKey());
        this.enabledFeatures.remove(feature.enabledFeatureKey());
        return this;
    }

    public MockFeatureManager registerFeatureFlag(FeatureFlag feature) {
        this.registeredFeatureFlags.add(feature);
        return this;
    }

    public MockFeatureManager unregisterFeatureFlag(FeatureFlag feature) {
        this.registeredFeatureFlags.remove(feature);
        return this;
    }

    public MockFeatureManager activateFeatureFlag(FeatureFlag featureFlag) {
        this.activatedFeatureFlags.add(featureFlag);
        return this;
    }

    public MockFeatureManager deactivateFeatureFlag(FeatureFlag featureFlag) {
        this.activatedFeatureFlags.remove(featureFlag);
        return this;
    }

    public Set<String> getEnabledFeatureKeys() {
        return this.enabledFeatures;
    }

    public DarkFeatures getDarkFeatures() {
        return this.darkFeatures;
    }

    public Set<FeatureFlag> getRegisteredFlags() {
        HashSet flags = Sets.newHashSet();
        for (String s : this.enabledFeatures) {
            flags.add(FeatureFlag.featureFlag((String)s));
        }
        return flags;
    }

    public void enableUserDarkFeature(ApplicationUser user, String feature) {
        HashSet userFeatures = Sets.newHashSet((Iterable)this.darkFeatures.getUserEnabledFeatures());
        userFeatures.add(feature);
        this.darkFeatures = new DarkFeatures(this.darkFeatures.getSystemEnabledFeatures(), this.darkFeatures.getSiteEnabledFeatures(), (Set)userFeatures);
    }

    public void disableUserDarkFeature(ApplicationUser user, String feature) {
        HashSet userFeatures = Sets.newHashSet((Iterable)this.darkFeatures.getUserEnabledFeatures());
        userFeatures.remove(feature);
        this.darkFeatures = new DarkFeatures(this.darkFeatures.getSystemEnabledFeatures(), this.darkFeatures.getSiteEnabledFeatures(), (Set)userFeatures);
    }

    public void enableSiteDarkFeature(String feature) {
        HashSet siteFeature = Sets.newHashSet((Iterable)this.darkFeatures.getSiteEnabledFeatures());
        siteFeature.add(feature);
        this.darkFeatures = new DarkFeatures(this.darkFeatures.getSystemEnabledFeatures(), (Set)siteFeature, this.darkFeatures.getUserEnabledFeatures());
    }

    public void disableSiteDarkFeature(String feature) {
        HashSet siteFeature = Sets.newHashSet((Iterable)this.darkFeatures.getSiteEnabledFeatures());
        siteFeature.remove(feature);
        this.darkFeatures = new DarkFeatures(this.darkFeatures.getSystemEnabledFeatures(), (Set)siteFeature, this.darkFeatures.getUserEnabledFeatures());
    }

    public boolean hasSiteEditPermission() {
        return true;
    }

    public DarkFeatures getDarkFeaturesForUser(@Nullable ApplicationUser user) {
        return this.getDarkFeatures();
    }

    public boolean isEnabledForUser(ApplicationUser user, String featureKey) {
        return this.isEnabled(featureKey);
    }

    public static class AllDarkFeaturesDisabled {
        public static MockFeatureManager get() {
            return new MockFeatureManager();
        }
    }
}

