/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerManager;
import java.util.HashMap;
import java.util.Map;

public class MockListenerManager
implements ListenerManager {
    private final Map<String, JiraListener> listeners = new HashMap<String, JiraListener>();

    public Map<String, JiraListener> getListeners() {
        return this.listeners;
    }

    public JiraListener createListener(String name, Class<? extends JiraListener> clazz) {
        try {
            JiraListener listener = clazz.newInstance();
            this.addListener(name, listener);
            return listener;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteListener(Class<? extends JiraListener> clazz) {
        for (Map.Entry<String, JiraListener> entry : this.listeners.entrySet()) {
            if (!entry.getValue().getClass().equals(clazz)) continue;
            this.listeners.remove(entry.getKey());
        }
    }

    public void addListener(String name, JiraListener listener) {
        this.listeners.put(name, listener);
    }

    public void refresh() {
        this.listeners.clear();
    }

    public void onRefreshListeners() {
        this.listeners.clear();
    }
}

