/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.plugin;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class MockPluginAccessor
implements PluginAccessor {
    private Map<String, Plugin> plugins = Maps.newLinkedHashMap();

    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    public MockPluginAccessor addPlugins(Plugin ... plugins) {
        for (Plugin plugin : plugins) {
            this.addPlugin(plugin);
        }
        return this;
    }

    public MockPluginAccessor addPlugin(Plugin plugin) {
        this.plugins.put(plugin.getKey(), plugin);
        return this;
    }

    public Collection<Plugin> getPlugins(final PluginPredicate pluginPredicate) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.plugins.values(), (Predicate)new Predicate<Plugin>(){

            public boolean apply(@Nullable Plugin input) {
                return pluginPredicate.matches(input);
            }
        }));
    }

    public Collection<Plugin> getEnabledPlugins() {
        return this.getPlugins(new PluginPredicate(){

            public boolean matches(Plugin plugin) {
                return MockPluginAccessor.this.isPluginEnabled(plugin.getKey());
            }
        });
    }

    public <M> Collection<M> getModules(ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <M> Collection<ModuleDescriptor<M>> getModuleDescriptors(ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Plugin getPlugin(String key) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Plugin getEnabledPlugin(String pluginKey) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ModuleDescriptor<?> getPluginModule(String completeKey) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ModuleDescriptor<?> getEnabledPluginModule(String completeKey) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isPluginEnabled(String key) throws IllegalArgumentException {
        return this.plugins.containsKey(key);
    }

    public boolean isPluginModuleEnabled(String completeKey) {
        String[] split = completeKey.split(":");
        return this.isPluginEnabled(split[0]);
    }

    public <M> List<M> getEnabledModulesByClass(Class<M> moduleClass) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>>[] descriptorClazz, Class<M> moduleClass) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>> moduleDescriptorClass, Class<M> moduleClass) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz) {
        ArrayList data = Lists.newArrayList();
        for (Plugin plugin : this.getEnabledPlugins()) {
            for (ModuleDescriptor module : plugin.getModuleDescriptors()) {
                if (!descriptorClazz.isInstance(module) || !this.isPluginModuleEnabled(module.getCompleteKey())) continue;
                data.add(descriptorClazz.cast(module));
            }
        }
        return data;
    }

    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz, boolean verbose) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <M> List<ModuleDescriptor<M>> getEnabledModuleDescriptorsByType(String type) throws PluginParseException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public InputStream getDynamicResourceAsStream(String resourcePath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public InputStream getPluginResourceAsStream(String pluginKey, String resourcePath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Class<?> getDynamicPluginClass(String className) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isSystemPlugin(String key) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PluginRestartState getPluginRestartState(String key) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterable<ModuleDescriptor<?>> getDynamicModules(Plugin plugin) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

