/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.security;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.MockI18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class MockAuthenticationContext
implements JiraAuthenticationContext {
    private final I18nHelper i18nHelper;
    private ApplicationUser user;

    public MockAuthenticationContext(@Nullable ApplicationUser user) {
        this(user, null);
    }

    public MockAuthenticationContext(@Nullable ApplicationUser user, @Nullable I18nHelper i18nHelper) {
        this.i18nHelper = (I18nHelper)ObjectUtils.defaultIfNull((Object)i18nHelper, (Object)((Object)new MockI18nBean()));
        this.user = user;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public ApplicationUser getLoggedInUser() {
        return this.user;
    }

    public boolean isLoggedInUser() {
        return this.user != null;
    }

    public Locale getLocale() {
        return this.i18nHelper.getLocale();
    }

    public OutlookDate getOutlookDate() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getText(String key) {
        return this.getI18nHelper().getText(key);
    }

    @Nonnull
    public I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    public I18nHelper getI18nBean() {
        return this.getI18nHelper();
    }

    public void setLoggedInUser(ApplicationUser user) {
        this.user = user;
    }

    public void clearLoggedInUser() {
        this.user = null;
    }
}

