/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.servlet;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class MockHttpServletResponse
implements HttpServletResponse {
    private ServletOutputStream servletOutputStream;
    private PrintWriter writer;
    private int status;
    private String contentType;
    private String redirect;
    private final List<Cookie> cookies = Lists.newArrayList();
    private ListMultimap<String, String> headers = ArrayListMultimap.create();

    public MockHttpServletResponse() {
    }

    public MockHttpServletResponse(ServletOutputStream servletOutputStream) {
        this.servletOutputStream = servletOutputStream;
    }

    public MockHttpServletResponse(PrintWriter writer) {
        this.writer = writer;
    }

    public MockHttpServletResponse(StringWriter writer) {
        this.writer = new PrintWriter(writer);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Iterable<Cookie> getCookies() {
        return ImmutableList.copyOf(this.cookies);
    }

    public boolean containsHeader(String s) {
        return false;
    }

    public String encodeURL(String s) {
        return null;
    }

    public String encodeRedirectURL(String s) {
        return null;
    }

    public String encodeUrl(String s) {
        return null;
    }

    public String encodeRedirectUrl(String s) {
        return null;
    }

    public void sendError(int i, String s) throws IOException {
        this.status = i;
    }

    public void sendError(int i) throws IOException {
        this.status = i;
    }

    public void sendRedirect(String s) throws IOException {
        this.status = 302;
        this.redirect = s;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public void setDateHeader(String s, long l) {
    }

    public void addDateHeader(String s, long l) {
    }

    public void setHeader(String name, String value) {
        this.headers.put((Object)name.toLowerCase(Locale.US), (Object)value);
    }

    public String getHeader(String name) {
        List allHeaders = this.headers.get((Object)name.toLowerCase(Locale.US));
        return allHeaders.isEmpty() ? null : (String)allHeaders.get(0);
    }

    public void addHeader(String name, String value) {
        this.setHeader(name, value);
    }

    public void setIntHeader(String s, int i) {
    }

    public void addIntHeader(String s, int i) {
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public void setStatus(int i, String s) {
        this.status = i;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void setCharacterEncoding(String s) {
    }

    public void setContentLength(int i) {
    }

    public void setContentType(String ct) {
        this.contentType = ct;
    }

    public void setBufferSize(int i) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale locale) {
    }

    public Locale getLocale() {
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false, MockHttpServletResponse.class);
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.get((Object)name.toLowerCase(Locale.US));
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableCollection(this.headers.keySet());
    }
}

