/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.groups;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.MockApplicationUser;
import com.atlassian.jira.user.MockCrowdService;
import com.atlassian.jira.user.MockGroup;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.Pages;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockGroupManager
implements GroupManager {
    private Map<String, Group> groupMap = new HashMap<String, Group>();
    private Map<String, Exception> groupExceptionMap = new HashMap<String, Exception>();
    private SetMultimap<String, ApplicationUser> membershipMap = HashMultimap.create();
    private SetMultimap<String, Group> userToGroups = HashMultimap.create();
    private final CrowdService crowdService;

    public MockGroupManager() {
        this(new MockCrowdService());
    }

    public MockGroupManager(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public Collection<Group> getAllGroups() {
        return this.groupMap.values();
    }

    public boolean groupExists(String groupName) {
        return this.groupMap.containsKey(groupName);
    }

    public boolean groupExists(@Nonnull Group group) {
        return this.groupExists(group.getName());
    }

    public Group createGroup(String groupName) {
        if (this.groupExceptionMap.containsKey(groupName)) {
            MockGroupManager.throwCheckedException(this.groupExceptionMap.get(groupName));
        }
        this.groupMap.put(groupName, (Group)new ImmutableGroup(groupName));
        return this.groupMap.get(groupName);
    }

    public <T extends Exception> void throwExceptionOnCreateGroup(String groupName, Exception cause) {
        this.groupExceptionMap.put(groupName, cause);
    }

    private static <T extends Throwable> void throwCheckedException(Throwable exception) throws T {
        throw exception;
    }

    public Group getGroup(String groupName) {
        return this.groupMap.get(groupName);
    }

    public Group getGroupEvenWhenUnknown(String groupName) {
        if (this.groupMap.containsKey(groupName)) {
            return this.groupMap.get(groupName);
        }
        return new ImmutableGroup(groupName);
    }

    public Group getGroupObject(String groupName) {
        return this.groupMap.get(groupName);
    }

    public boolean isUserInGroup(@Nullable String username, @Nullable String groupName) {
        Set members = this.membershipMap.get((Object)groupName);
        return members != null && Iterables.any((Iterable)members, user -> user.getUsername().equalsIgnoreCase(username));
    }

    public boolean isUserInGroup(@Nullable ApplicationUser user, @Nullable Group group) {
        Set members = this.membershipMap.get((Object)group.getName());
        return members != null && members.contains(user);
    }

    public boolean isUserInGroup(@Nullable ApplicationUser user, @Nullable String groupName) {
        return user != null && this.isUserInGroup(user.getUsername(), groupName);
    }

    public Collection<ApplicationUser> getUsersInGroup(String groupName) {
        return this.membershipMap.get((Object)groupName);
    }

    public Collection<ApplicationUser> getUsersInGroup(String groupName, Boolean includeInactive) {
        return this.getUsersInGroup(groupName).stream().filter(u -> includeInactive != false || u.isActive()).collect(Collectors.toList());
    }

    public Page<ApplicationUser> getUsersInGroup(String groupName, Boolean active, PageRequest pageRequest) {
        Set applicationUsers = this.membershipMap.get((Object)groupName).stream().filter(u -> active != false || u.isActive()).collect(Collectors.toSet());
        return Pages.toPage(applicationUsers, (PageRequest)pageRequest);
    }

    public Collection<ApplicationUser> getUsersInGroup(Group group) {
        return this.membershipMap.get((Object)group.getName());
    }

    public int getUsersInGroupCount(Group group) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getUsersInGroupCount(String groupName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<String> getNamesOfDirectMembersOfGroups(Collection<String> groupNames, int limit) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<String> filterUsersInAllGroupsDirect(Collection<String> userNames, Collection<String> groupNames) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<String> getUserNamesInGroup(Group group) {
        return this.getUserNamesInGroup(group.getName());
    }

    public Collection<String> getUserNamesInGroups(Collection<Group> groups) {
        ArrayList users = Lists.newArrayList();
        for (Group group : groups) {
            users.addAll(this.getUserNamesInGroup(group));
        }
        return ImmutableSet.copyOf((Collection)users);
    }

    public Collection<String> getUserNamesInGroup(String groupName) {
        ArrayList usernames = Lists.newArrayList();
        usernames.addAll(this.getUsersInGroup(groupName).stream().map(user -> user.getName()).collect(Collectors.toList()));
        return usernames;
    }

    public Collection<ApplicationUser> getDirectUsersInGroup(Group group) {
        return this.getUsersInGroup(group);
    }

    public Collection<Group> getGroupsForUser(String userName) {
        Set groups = this.userToGroups.get((Object)userName);
        if (groups != null) {
            return groups;
        }
        return Collections.emptySet();
    }

    public Collection<Group> getGroupsForUser(ApplicationUser user) {
        Set groups = this.userToGroups.get((Object)user.getName());
        if (groups != null) {
            return groups;
        }
        return Collections.emptySet();
    }

    public Collection<String> getGroupNamesForUser(String userName) {
        Set groups = this.userToGroups.get((Object)userName);
        if (groups == null) {
            return Collections.emptySet();
        }
        return (Collection)groups.stream().map(Group::getName).sorted().collect(CollectorsUtil.toImmutableListWithSizeOf((Collection)groups));
    }

    public Collection<String> getGroupNamesForUser(@Nonnull ApplicationUser user) {
        return this.getGroupNamesForUser(user.getName());
    }

    public void addUserToGroup(ApplicationUser user, Group group) {
        this.groupMap.put(group.getName(), group);
        this.membershipMap.put((Object)group.getName(), (Object)user);
        this.userToGroups.put((Object)user.getName(), (Object)group);
    }

    @Deprecated
    public Set<ApplicationUser> getConnectUsers() {
        return ImmutableSet.of();
    }

    public Group addGroup(String groupName) {
        ImmutableGroup group = new ImmutableGroup(groupName);
        this.addGroup((Group)group);
        return group;
    }

    public MockGroupManager addGroup(Group group) {
        this.groupMap.put(group.getName(), group);
        return this;
    }

    public void addMember(String groupName, String userName) {
        MockGroup group = new MockGroup(groupName);
        MockApplicationUser user = new MockApplicationUser(userName);
        this.addUserToGroup(user, group);
    }

    public MockGroupManager setUserMembership(ApplicationUser user, Group ... groups) {
        Iterator iterator = this.membershipMap.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!((ApplicationUser)entry.getValue()).equals((Object)user)) continue;
            iterator.remove();
        }
        Arrays.asList(groups).forEach(g -> this.addUserToGroup(user, (Group)g));
        return this;
    }
}

