/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.test;

import com.atlassian.jira.web.ServletContextProviderListener;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.junit.rules.ExternalResource;
import org.mockito.Mockito;

public class ServletContextProviderRule
extends ExternalResource {
    private final ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
    private final ServletContextEvent servletContextEvent;
    private final ServletContextProviderListener servletContextProviderListener = new ServletContextProviderListener();

    @Nonnull
    public static ServletContextProviderRule setUpServletContextProvider() {
        return new ServletContextProviderRule();
    }

    ServletContextProviderRule() {
        this.servletContextEvent = new ServletContextEvent(this.servletContext);
    }

    protected void before() throws Throwable {
        this.servletContextProviderListener.contextInitialized(this.servletContextEvent);
    }

    protected void after() {
        this.servletContextProviderListener.contextDestroyed(this.servletContextEvent);
    }

    @Nonnull
    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

