/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MockUser
implements UserWithAttributes,
Serializable {
    public static final long MOCK_DIRECTORY_ID = 1L;
    private String name;
    private String fullName;
    private String email;
    private Map<String, Set<String>> values;
    private boolean active = true;
    private long directoryId = 1L;

    public MockUser(String username) {
        this(username, "", null, null);
    }

    public MockUser(String username, long directoryId) {
        this(username, "", null, directoryId);
    }

    public MockUser(String username, String fullName, String email) {
        this(username, fullName, email, null);
    }

    public MockUser(String username, String fullName, String email, long directoryId) {
        this(username, fullName, email, null);
        this.directoryId = directoryId;
    }

    public MockUser(String username, String fullName, String email, Map<String, Set<String>> values) {
        this.name = username;
        this.fullName = fullName;
        this.email = email;
        this.values = values == null ? Collections.emptyMap() : values;
    }

    public boolean isActive() {
        return this.active;
    }

    public MockUser setActive(boolean active) {
        this.active = active;
        return this;
    }

    public String getEmailAddress() {
        return this.email;
    }

    public String getDisplayName() {
        return this.fullName;
    }

    public void setDirectoryId(long id) {
        this.directoryId = id;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "<User " + this.name + ">";
    }

    public Set<String> getValues(String key) {
        return this.values.get(key);
    }

    public String getValue(String key) {
        Set<String> allValues = this.values.get(key);
        if (allValues != null && allValues.size() > 0) {
            return allValues.iterator().next();
        }
        return null;
    }

    public Set<String> getKeys() {
        return this.values.keySet();
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    public boolean equals(Object o) {
        return o instanceof User && UserComparator.equal((User)this, (User)((User)o));
    }

    public int hashCode() {
        return UserComparator.hashCode((User)this);
    }

    public int compareTo(User other) {
        return UserComparator.compareTo((User)this, (User)other);
    }
}

