/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.mock.propertyset.MockPropertySet;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import javax.annotation.Nonnull;

public class MockUserPropertyManager
implements UserPropertyManager {
    private final Map<String, PropertySet> mappings = Maps.newHashMap();

    @Nonnull
    public PropertySet getPropertySet(ApplicationUser user) {
        return this.mappings.get(user.getKey());
    }

    @Nonnull
    public PropertySet getPropertySetForUserKey(String userkey) {
        return this.mappings.get(userkey);
    }

    public PropertySet createOrGetForUser(ApplicationUser user) {
        return this.createOrGetForKey(user.getKey());
    }

    public PropertySet createOrGetForKey(String key) {
        PropertySet userProperties = this.mappings.get(key);
        if (userProperties == null) {
            userProperties = new MockPropertySet();
            this.mappings.put(key, userProperties);
        }
        return userProperties;
    }
}

