/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MockUserKeyStore
implements UserKeyStore {
    private boolean useDefaultMapping = true;
    private Map<String, String> keyToUsernameMap = new HashMap<String, String>();
    private Map<String, String> usernameToKeyMap = new HashMap<String, String>();

    public String getUsernameForKey(String key) {
        if (this.useDefaultMapping) {
            return key;
        }
        return this.keyToUsernameMap.get(key);
    }

    public String getKeyForUsername(String username) {
        if (username == null) {
            return null;
        }
        String lowerUsername = IdentifierUtils.toLowerCase((String)username);
        if (username == null) {
            return null;
        }
        if (this.useDefaultMapping) {
            return lowerUsername;
        }
        return this.usernameToKeyMap.get(lowerUsername);
    }

    public void renameUser(String oldUsername, String newUsername) {
        oldUsername = IdentifierUtils.toLowerCase((String)oldUsername);
        newUsername = IdentifierUtils.toLowerCase((String)newUsername);
        String userkey = this.usernameToKeyMap.remove(oldUsername);
        this.usernameToKeyMap.put(newUsername, userkey);
        this.keyToUsernameMap.put(userkey, newUsername);
    }

    public String ensureUniqueKeyForNewUser(String username) {
        String lowerUsername = IdentifierUtils.toLowerCase((String)username);
        if (this.useDefaultMapping) {
            return lowerUsername;
        }
        if (this.usernameToKeyMap.containsKey(lowerUsername)) {
            return this.usernameToKeyMap.get(lowerUsername);
        }
        String userkey = this.keyToUsernameMap.containsKey(lowerUsername) ? this.findUniqueKey() : lowerUsername;
        this.usernameToKeyMap.put(lowerUsername, userkey);
        this.keyToUsernameMap.put(userkey, lowerUsername);
        return userkey;
    }

    public String removeByKey(String key) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setMapping(String key, String username) {
        this.keyToUsernameMap.put(key, username);
        this.usernameToKeyMap.put(IdentifierUtils.toLowerCase((String)username), key);
    }

    private String findUniqueKey() {
        for (int id = 10001; id < 11000; ++id) {
            String potentialKey = "XYZ" + id;
            if (this.keyToUsernameMap.containsKey(potentialKey)) continue;
            return potentialKey;
        }
        throw new IllegalStateException("WTF!");
    }

    public Long getIdForUserKey(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Optional<ApplicationUserEntity> getUserForId(Long id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Optional<ApplicationUserEntity> getUserForKey(String key) {
        String username = this.useDefaultMapping ? key : this.keyToUsernameMap.get(key);
        return Optional.ofNullable(username).map(name -> new ApplicationUserEntity(Long.valueOf(-1L), key, name));
    }

    public Optional<ApplicationUserEntity> getUserForUsername(String username) {
        String key = this.useDefaultMapping ? username : this.usernameToKeyMap.get(username);
        return Optional.ofNullable(key).map(k -> new ApplicationUserEntity(Long.valueOf(-1L), k, username));
    }

    public void useDefaultMapping(boolean useDefaultMapping) {
        this.useDefaultMapping = useDefaultMapping;
    }
}

