/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import java.util.Collection;
import java.util.Map;

public interface ClassMap {
    public <T> T get(Class<T> var1);

    public <T> void put(Class<T> var1, T var2);

    public <T> void put(T var1);

    public Collection<? extends Class<?>> keySet();

    public Collection<?> values();

    public static class Impl
    implements ClassMap {
        private final Map<Class<?>, Object> delegate;

        Impl(Map<Class<?>, Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T> void put(T instance) {
            Class klass = (Class)Class.class.cast(instance.getClass());
            this.put(klass, instance);
        }

        @Override
        public <T> void put(Class<T> klass, T instance) {
            this.delegate.put(klass, instance);
        }

        @Override
        public Collection<? extends Class<?>> keySet() {
            return this.delegate.keySet();
        }

        public Collection<? extends Object> values() {
            return this.delegate.values();
        }

        @Override
        public <T> T get(Class<T> klass) {
            return klass.cast(this.delegate.get(klass));
        }
    }

    public static class Factory {
        public static ClassMap create(Map<Class<?>, Object> delegate) {
            return new Impl(delegate);
        }
    }
}

