/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.searchers;

import com.atlassian.jira.index.LuceneVersion;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class MockSearcherFactory {
    public static Directory getCleanRAMDirectory() {
        try {
            RAMDirectory directory = new RAMDirectory();
            IndexWriterConfig conf = new IndexWriterConfig(LuceneVersion.get(), (Analyzer)new StandardAnalyzer(LuceneVersion.get()));
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            new IndexWriter((Directory)directory, conf).close();
            return directory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher getSearcher(Directory directory) {
        try {
            return new IndexSearcher(directory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher getCleanSearcher() {
        return MockSearcherFactory.getSearcher(MockSearcherFactory.getCleanRAMDirectory());
    }
}

