/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.listener;

import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.util.SectionKey;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;

public final class JqlFilterStoreUtils {
    private static SectionKey ISSUES_SECTION = new SectionKey("issue-related-events-section");

    public static JqlAwarePersistentListenerBuilder persistentListenerBuilder(@Nonnull Integer id) {
        return new JqlAwarePersistentListenerBuilder(PersistentWebHookListener.existing((Integer)id));
    }

    public static String getJqlFilter(PersistentWebHookListener listener) {
        return listener.getFilterFor(ISSUES_SECTION);
    }

    public static final class JqlAwarePersistentListenerBuilder {
        private final PersistentWebHookListener.Builder builder;

        private JqlAwarePersistentListenerBuilder(PersistentWebHookListener.Builder builder) {
            this.builder = builder;
        }

        public JqlAwarePersistentListenerBuilder setListenerName(String listenerName) {
            this.builder.setListenerName(listenerName);
            return this;
        }

        public JqlAwarePersistentListenerBuilder setLastUpdated(Date lastUpdated) {
            this.builder.setLastUpdated(lastUpdated);
            return this;
        }

        public JqlAwarePersistentListenerBuilder addWebHookIds(Collection<String> webHookIds) {
            this.builder.addWebHookIds(webHookIds);
            return this;
        }

        public JqlAwarePersistentListenerBuilder setLastUpdatedByUser(String lastUpdatedByUser) {
            this.builder.setLastUpdatedByUser(lastUpdatedByUser);
            return this;
        }

        public JqlAwarePersistentListenerBuilder setUrl(String url) {
            this.builder.setUrl(url);
            return this;
        }

        public JqlAwarePersistentListenerBuilder setExcludeBody(boolean excludeBody) {
            this.builder.setExcludeBody(excludeBody);
            return this;
        }

        public JqlAwarePersistentListenerBuilder setEnabled(boolean enabled) {
            this.builder.setEnabled(enabled);
            return this;
        }

        public JqlAwarePersistentListenerBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        public JqlAwarePersistentListenerBuilder setJqlFilter(String filter) {
            this.builder.addFilter(ISSUES_SECTION.getValue(), filter);
            return this;
        }

        public PersistentWebHookListener build() {
            return this.builder.build();
        }
    }
}

