/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.matcher;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.ThreadLocalSearcherCache;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.plugins.webhooks.validation.JqlValidationUtil;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.query.Query;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.spi.EventMatcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JqlEventMatcher<T extends IssueRelatedEvent>
implements EventMatcher<T> {
    private final SearchService searchService;
    private final JqlQueryParser jqlQueryParser;
    private final JqlValidationUtil jqlValidationUtil;
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    private static final Logger slowLog = Logger.getLogger((String)(JqlEventMatcher.class.getName() + "_SLOW"));
    private static final Logger log = Logger.getLogger((String)JqlEventMatcher.class.getName());

    @Autowired
    public JqlEventMatcher(SearchService searchService, JqlQueryParser jqlQueryParser, JqlValidationUtil jqlValidationUtil, JiraThreadLocalUtil jiraThreadLocalUtil) {
        this.searchService = searchService;
        this.jqlQueryParser = jqlQueryParser;
        this.jqlValidationUtil = jqlValidationUtil;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    public boolean matches(T event, WebHookListener listener) {
        return this.matchJql(listener.getParameters().getFilter(), event.getIssue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchJql(String filter, Issue issue) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return true;
        }
        if (!this.jqlValidationUtil.isJqlValid(filter).isRight()) {
            log.error((Object)String.format("The following JQL query '%-1.800s' defined for filtering webhook events is incorrect. Filtering has been disabled for webhook.", filter));
            return true;
        }
        try {
            Query query = this.getQuery(issue.getKey(), filter);
            long startTime = System.currentTimeMillis();
            this.jiraThreadLocalUtil.preCall();
            ThreadLocalSearcherCache.startSearcherContext();
            boolean matches = this.searchService.searchCountOverrideSecurity(null, query) > 0L;
            long queryTime = System.currentTimeMillis() - startTime;
            if (queryTime > 50L) {
                String logMessage = String.format("JQL query '%-1.800s' produced lucene query and took '%d' ms to run.", query.toString(), queryTime);
                slowLog.info((Object)logMessage);
            }
            boolean bl = matches;
            return bl;
        }
        catch (SearchException e) {
            boolean bl = false;
            return bl;
        }
        catch (JqlParseException e) {
            log.error((Object)"Query could not be parsed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadLocalSearcherCache.stopAndCloseSearcherContext();
            this.jiraThreadLocalUtil.postCall();
        }
    }

    private Query getQuery(String issueKey, String filter) throws JqlParseException {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)this.jqlQueryParser.parseQuery(filter));
        return queryBuilder.where().and().issue(new String[]{issueKey}).buildQuery();
    }
}

