/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.rest;

import com.atlassian.jira.plugins.webhooks.workflow.WorkflowUtil;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.webhooks.api.register.listener.WebHookListenerService;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="jira-webhook")
public class JiraWebHookResource {
    private final WebHookListenerService webHookListenerService;
    private final WorkflowUtil workflowUtil;

    @Inject
    public JiraWebHookResource(WebHookListenerService webHookListenerService, WorkflowUtil workflowUtil) {
        this.workflowUtil = (WorkflowUtil)Preconditions.checkNotNull((Object)workflowUtil);
        this.webHookListenerService = (WebHookListenerService)Preconditions.checkNotNull((Object)webHookListenerService);
    }

    @GET
    @Path(value="{id}/transitions")
    public Response getTransitions(@PathParam(value="id") int id) {
        return (Response)this.webHookListenerService.getWebHookListener(id).fold((java.util.function.Supplier)((Supplier)() -> ((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never())).build()), (java.util.function.Function)((Function)listener -> Response.ok(this.workflowUtil.getTransitionLinkedToWebHookListener(id)).cacheControl(CacheControl.never()).build()));
    }
}

