/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.jira.project.Project;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;

@ExperimentalApi
public class RapidViewQuery {
    private static final RapidViewQuery EMPTY_QUERY = new RapidViewQuery(EnumSet.allOf(RapidView.Type.class), null, null);
    private final Set<RapidView.Type> types;
    private final String partialName;
    private final Project project;

    private RapidViewQuery(Set<RapidView.Type> types, String partialName, Project project) {
        this.types = types;
        this.partialName = partialName;
        this.project = project;
    }

    public Set<RapidView.Type> getTypes() {
        return this.types;
    }

    @Nullable
    public String getPartialName() {
        return this.partialName;
    }

    public Project getProject() {
        return this.project;
    }

    public static RapidViewQuery noQuery() {
        return EMPTY_QUERY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<RapidView.Type> types = EnumSet.allOf(RapidView.Type.class);
        private String partialName;
        private Project project;

        public Builder types(Set<RapidView.Type> types) {
            this.types = types;
            return this;
        }

        public Builder partialName(String partialName) {
            this.partialName = partialName;
            return this;
        }

        public Builder project(Project project) {
            this.project = project;
            return this;
        }

        public RapidViewQuery build() {
            return new RapidViewQuery(this.types, this.partialName, this.project);
        }
    }
}

