/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.subquery;

import com.atlassian.jira.entity.WithId;
import java.util.Objects;

public class Subquery
implements WithId {
    private final Long id;
    private final String query;

    private Subquery(Long id, String query) {
        this.id = id;
        this.query = query;
    }

    public Long getId() {
        return this.id;
    }

    public String getQuery() {
        return this.query;
    }

    public static SubqueryBuilder builder() {
        return new SubqueryBuilder();
    }

    public static SubqueryBuilder builder(Subquery data) {
        return new SubqueryBuilder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subquery that = (Subquery)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getQuery(), that.getQuery());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getQuery());
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("query", (Object)this.getQuery()).toString();
    }

    public static final class SubqueryBuilder {
        private Long id;
        private String query;

        private SubqueryBuilder() {
        }

        private SubqueryBuilder(Subquery initialData) {
            this.id = initialData.getId();
            this.query = initialData.getQuery();
        }

        public SubqueryBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SubqueryBuilder emptyQuery() {
            this.query("");
            return this;
        }

        public SubqueryBuilder query(String query) {
            this.query = query;
            return this;
        }

        public Subquery build() {
            return new Subquery(this.id, this.query);
        }
    }
}

