define('jira-agile/gh-features', ["jira/ajs/dark-features"], function(DarkFeatures) {
    "use strict";

    function Feature(featureKey) {
        this.featureKey = featureKey;
        this.featureEmergencyDisabledKey = featureKey + '.emergencyDisabled';
    }

    Feature.prototype.isEnabled = function() {
        return DarkFeatures.isEnabled(this.featureKey) && !DarkFeatures.isEnabled(this.featureEmergencyDisabledKey);
    };

    return Object.freeze({
        DISABLE_CREATE_PROJECT: new Feature("jag.DISABLE_CREATE_PROJECT"),
        EDITABLE_DETAIL_VIEW_ENABLED: new Feature("com.atlassian.jira.agile.darkfeature.editable.detailsview"),
        SPLIT_ISSUE: new Feature("com.atlassian.jira.agile.darkfeature.splitissue")
    });
});

AJS.namespace('GH.Features', null, require('jira-agile/gh-features'));
