GH.ajsVersion = function() {

    if (!AJS.version) {
        return {
            major: -1,
            minor: 0,
            milestone: 0
        };
    }

    var version = AJS.version.split(".");
    var vObj = {
        major: version[0],
        minor: 0,
        milestone: 0
    };

    if (version.length == 3) {
        vObj.minor = version[1];
        vObj.milestone = version[2];
    } else if (version.length == 2) {
        var s = version[1].split("-");
        if (s.length == 2) {
            vObj.minor = s[0];
            vObj.milestone = s[1].substring(s[1].indexOf("m")+1);
        }
    }

    return vObj;
};

GH.ajsVersionAfter = function(major, minor, milestone) {

    var v = GH.ajsVersion();

    if (v.major < major) {
        return false;
    }
    if (minor && v.minor < minor) {
        return false;
    }
    if (milestone && v.milestone < milestone) {
        return false;
    }
    return true;

};