/**
 * Plugin that fires flotMouseEnter and flotMouseLeave events on the chart container
 * as well as a "mouseEntered" flag on the plot itself.
 */
(function ($) {
    var options = {
        mouseEnterExitEvents: false
    };

    function init(plot) {
        plot.hooks.bindEvents.push(function(plot, eventholder) {
            var handleMouseMove = function(event) {
                if (!plot.getOptions().mouseEnterExitEvents) return;
                if (!plot.mouseEntered) {
                    plot.mouseEntered = true;
                    GH.log('triggering flotMouseEnter', GH.Logger.Contexts.ui);
                    plot.getPlaceholder().trigger('flotMouseEnter', plot);
                }
            };
            var handleMouseLeave = function(event) {
                if (!plot.getOptions().mouseEnterExitEvents) return;
                if (plot.mouseEntered) {
                    plot.mouseEntered = false;
                    GH.log('triggering flotMouseLeave', GH.Logger.Contexts.ui);
                    plot.getPlaceholder().trigger('flotMouseLeave', plot);
                }
            };
            eventholder.mousemove(handleMouseMove);
            eventholder.mouseleave(handleMouseLeave);
        });
    }
    // register the plugin with flot. This has to happen once, before the charts are drawn.
    AJS.$.plot.plugins.push({
        init: init,
        options: options,
        name: 'gh-mouseenterexit-events',
        version: '1.0'
    });
})(AJS.$);
