AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function () {
    var DurationsTimer = require('jira-agile/rapid/durations-timer');
    module("DurationsTimer tests", {
        setup: function setup() {
            this.clock = sinon.useFakeTimers();
            this.timer = new DurationsTimer([10, 30, 100]);
            this.tickHandler = sinon.spy();
            this.timer.on('tick', this.tickHandler);
        },
        teardown: function teardown() {
            this.clock.restore();
        }
    });

    test("Timer does tick", function () {
        var tickHandler = this.tickHandler;
        this.clock.tick(10);
        strictEqual(tickHandler.callCount, 1, "Tick handler was called");
        strictEqual(tickHandler.args[0][0], 10, "Tick handler was passed the duration that just expired");
        this.clock.tick(20);
        strictEqual(tickHandler.callCount, 2, "Tick handler was called");
        strictEqual(tickHandler.args[1][0], 30, "Tick handler was passed the duration that just expired");
        this.clock.tick(70);
        strictEqual(tickHandler.callCount, 3, "Tick handler was called");
        strictEqual(tickHandler.args[2][0], 100, "Tick handler was passed the duration that just expired");
    });

    test("Timer pauses and resumes correctly", function () {
        var tickHandler = this.tickHandler;
        this.clock.tick(5);
        this.timer.pause();
        this.clock.tick(100);
        this.timer.start();
        strictEqual(tickHandler.callCount, 0, "Tick handler not called because timer was paused");
        this.clock.tick(5);
        strictEqual(tickHandler.callCount, 1, "Timer is resumed, remembering the time that had passed before pausing");
        this.clock.tick(20);
        strictEqual(tickHandler.callCount, 2, "Tick handler was called");
        this.clock.tick(70);
        strictEqual(tickHandler.callCount, 3, "Tick handler was called");
    });

    test("Destroyed timer doesn't trigger events", function () {
        var tickHandler = this.tickHandler;
        this.clock.tick(5);
        this.timer.destroy();
        this.clock.tick(100);
        strictEqual(tickHandler.callCount, 0, "Tick handler not called because timer was destroyed");
    });
});